/*
 * Decompiled with CFR 0.152.
 */
package kareltherobot;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import kareltherobot.Directions;

public class World
implements Directions {
    private static World singletonWorld = null;
    private static boolean stateChanged = false;
    private boolean trace = true;
    private int nextRobotId = 0;
    protected Hashtable robots = new Hashtable();
    protected Vector walls = new Vector();
    protected Vector beepers = new Vector();
    protected int avenues = 15;
    protected int streets = 10;
    protected int delay = 1000;
    protected DelayThread delayThread = new DelayThread(false);

    public static World getWorld() {
        if (singletonWorld == null) {
            singletonWorld = new World();
        }
        return singletonWorld;
    }

    protected static final boolean registerWorld(World world) {
        if (stateChanged) {
            return false;
        }
        singletonWorld = world;
        return true;
    }

    protected World() {
    }

    protected void update() {
    }

    protected void trace(Robot robot) {
        stateChanged = true;
        if (this.trace) {
            System.out.println(robot);
        }
    }

    protected Robot getRobot(Integer robotId, boolean sync) {
        Robot result = (Robot)this.robots.get(robotId);
        if (result == null) {
            throw new RuntimeException("No such robot.");
        }
        if (!result.on) {
            throw new RuntimeException("Robot is turned off.");
        }
        if (!sync) {
            return result;
        }
        this.sync();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sync() {
        DelayThread delayThread = this.delayThread;
        try {
            delayThread.join();
        }
        catch (InterruptedException exception) {
            exception.printStackTrace();
        }
        World world = this;
        synchronized (world) {
            if (this.delayThread == delayThread) {
                this.delayThread = new DelayThread();
                this.delayThread.start();
            }
        }
    }

    public static void resetWalls() {
        World.getWorld().resetWallsInternal();
    }

    protected void resetWallsInternal() {
        this.walls = new Vector();
        this.update();
    }

    public static void resetBeepers() {
        World.getWorld().resetBeepersInternal();
    }

    protected void resetBeepersInternal() {
        this.beepers = new Vector();
        this.update();
    }

    public static void resetRobots() {
        World.getWorld().resetRobotsInternal();
    }

    protected void resetRobotsInternal() {
        this.robots = new Hashtable();
        this.nextRobotId = 0;
        this.update();
    }

    public static void placeBeepers(int street, int avenue, int count) {
        World.getWorld().placeBeepersInternal(street, avenue, count);
    }

    protected synchronized void placeBeepersInternal(int street, int avenue, int count) {
        Enumeration enumeration = this.beepers.elements();
        while (enumeration.hasMoreElements()) {
            Beepers current = (Beepers)enumeration.nextElement();
            if (current.avenue != avenue || current.street != street) continue;
            current.count += count;
            return;
        }
        Beepers newBeepers = new Beepers();
        newBeepers.avenue = avenue;
        newBeepers.street = street;
        newBeepers.count = count;
        this.beepers.add(newBeepers);
        this.update();
    }

    public static void placeEWWall(int northOfStreet, int atAvenue, int lengthTowardEast) {
        World.getWorld().placeEWWallInternal(northOfStreet, atAvenue, lengthTowardEast);
    }

    protected synchronized void placeEWWallInternal(int northOfStreet, int atAvenue, int lengthTowardEast) {
        while (lengthTowardEast > 0) {
            Wall wall = new Wall();
            wall.isEastWest = true;
            wall.avenue = atAvenue++;
            wall.street = northOfStreet;
            this.walls.add(wall);
            --lengthTowardEast;
        }
        this.update();
    }

    public static void placeNSWall(int atStreet, int eastOfAvenue, int lengthTowardNorth) {
        World.getWorld().placeNSWallInternal(atStreet, eastOfAvenue, lengthTowardNorth);
    }

    protected synchronized void placeNSWallInternal(int atStreet, int eastOfAvenue, int lengthTowardNorth) {
        while (lengthTowardNorth > 0) {
            Wall wall = new Wall();
            wall.isNorthSouth = true;
            wall.avenue = eastOfAvenue;
            wall.street = atStreet++;
            this.walls.add(wall);
            --lengthTowardNorth;
        }
        this.update();
    }

    public static void setSize(int streets, int avenues) {
        World.getWorld().setSizeInternal(streets, avenues);
    }

    protected synchronized void setSizeInternal(int streets, int avenues) {
        World.setAvenues(avenues);
        World.setStreets(streets);
        this.update();
    }

    public static void setStreets(int streets) {
        World.getWorld().setStreetsInternal(streets);
    }

    protected synchronized void setStreetsInternal(int streets) {
        this.streets = streets;
        if (this.streets < 1) {
            this.streets = 1;
        }
        this.update();
    }

    public static void setAvenues(int avenues) {
        World.getWorld().setAvenuesInternal(avenues);
    }

    protected synchronized void setAvenuesInternal(int avenues) {
        this.avenues = avenues;
        if (this.avenues < 1) {
            this.avenues = 1;
        }
        this.update();
    }

    public static void setDelay(int delay) {
        World.getWorld().setDelayInternal(delay);
    }

    protected void setDelayInternal(int delay) {
        this.delay = delay;
        this.update();
    }

    public static int delay() {
        return World.getWorld().delayInternal();
    }

    protected int delayInternal() {
        return this.delay;
    }

    public static boolean checkBeeper(int street, int avenue) {
        return World.getWorld().checkBeeperInternal(street, avenue);
    }

    protected boolean checkBeeperInternal(int street, int avenue) {
        Enumeration enumeration = this.beepers.elements();
        while (enumeration.hasMoreElements()) {
            Beepers currentBeepers = (Beepers)enumeration.nextElement();
            if (currentBeepers.street != street || currentBeepers.avenue != avenue) continue;
            return true;
        }
        return false;
    }

    public static boolean checkEWWall(int atStreet, int eastOfAvenue) {
        return World.getWorld().checkEWWallInternal(atStreet, eastOfAvenue);
    }

    protected boolean checkEWWallInternal(int atStreet, int eastOfAvenue) {
        Enumeration enumeration = this.walls.elements();
        while (enumeration.hasMoreElements()) {
            Wall currentWall = (Wall)enumeration.nextElement();
            if (!currentWall.isEastWest || currentWall.street != atStreet || currentWall.avenue != eastOfAvenue) continue;
            return true;
        }
        return false;
    }

    public static boolean checkNSWall(int northOfStreet, int atAvenue) {
        return World.getWorld().checkNSWallInternal(northOfStreet, atAvenue);
    }

    protected boolean checkNSWallInternal(int northOfStreet, int atAvenue) {
        Enumeration enumeration = this.walls.elements();
        while (enumeration.hasMoreElements()) {
            Wall currentWall = (Wall)enumeration.nextElement();
            if (!currentWall.isNorthSouth || currentWall.street != northOfStreet || currentWall.avenue != atAvenue) continue;
            return true;
        }
        return false;
    }

    public static void saveWorld(String filename) {
        World.getWorld().saveWorldInternal(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void saveWorldInternal(String filename) {
        PrintWriter writer = null;
        try {
            try {
                Object current;
                writer = new PrintWriter(new FileWriter(filename));
                writer.println("KarelWorld");
                writer.println("streets " + World.numberOfStreets());
                writer.println("avenues " + World.numberOfAvenues());
                Enumeration enumeration = this.beepers.elements();
                while (enumeration.hasMoreElements()) {
                    current = (Beepers)enumeration.nextElement();
                    writer.println("beepers " + ((Beepers)current).street + " " + ((Beepers)current).avenue + " " + ((Beepers)current).count);
                }
                enumeration = this.walls.elements();
                while (enumeration.hasMoreElements()) {
                    current = (Wall)enumeration.nextElement();
                    if (((Wall)current).isEastWest) {
                        writer.println("eastwestwalls " + ((Wall)current).street + " " + ((Wall)current).avenue + " " + ((Wall)current).avenue);
                        continue;
                    }
                    writer.println("northsouthwalls " + ((Wall)current).avenue + " " + ((Wall)current).street + " " + ((Wall)current).street);
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
                System.out.println("World no saved");
                Object var6_7 = null;
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            Object var6_6 = null;
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            throw throwable;
        }
    }

    public static void readWorld(String filename) {
        World.getWorld().readWorldInternal(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void readWorldInternal(String filename) {
        World.resetWalls();
        World.resetBeepers();
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(filename));
        while (reader.ready()) {
            StringTokenizer tokens = new StringTokenizer(reader.readLine(), " ", false);
            if (!tokens.hasMoreTokens()) continue;
            String action = tokens.nextToken();
            if (action.equalsIgnoreCase("streets")) {
                World.setStreets(Integer.parseInt(tokens.nextToken()));
                continue;
            }
            if (action.equalsIgnoreCase("avenues")) {
                World.setAvenues(Integer.parseInt(tokens.nextToken()));
                continue;
            }
            if (action.equalsIgnoreCase("beepers")) {
                World.placeBeepers(Integer.parseInt(tokens.nextToken()), Integer.parseInt(tokens.nextToken()), Integer.parseInt(tokens.nextToken()));
                continue;
            }
            if (action.equalsIgnoreCase("northsouthwalls")) {
                int eoa = Integer.parseInt(tokens.nextToken());
                int fs = Integer.parseInt(tokens.nextToken());
                int ls = Integer.parseInt(tokens.nextToken());
                World.placeNSWall(fs, eoa, ls - fs + 1);
                continue;
            }
            if (!action.equalsIgnoreCase("eastwestwalls")) continue;
            int nos = Integer.parseInt(tokens.nextToken());
            int fa = Integer.parseInt(tokens.nextToken());
            int la = Integer.parseInt(tokens.nextToken());
            World.placeEWWall(nos, fa, la - fa + 1);
        }
        Object var9_9 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException exception2) {}
        return;
        {
            catch (IOException exception) {
                exception.printStackTrace();
                System.out.println("No World read");
                Object var9_10 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException exception2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static int numberOfStreets() {
        return World.getWorld().numberOfStreetsInternal();
    }

    protected int numberOfStreetsInternal() {
        return this.streets;
    }

    public static int numberOfAvenues() {
        return World.getWorld().numberOfAvenuesInternal();
    }

    protected int numberOfAvenuesInternal() {
        return this.avenues;
    }

    public static void setTrace(boolean trace) {
        World.getWorld().setTraceInternal(trace);
    }

    protected void setTraceInternal(boolean trace) {
        this.trace = trace;
        this.update();
    }

    synchronized Integer getNewRobot(int street, int avenue, int direction, int beepers) {
        Integer currentRobotId = new Integer(this.nextRobotId);
        ++this.nextRobotId;
        Robot robot = new Robot();
        robot.id = this.nextRobotId - 1;
        robot.avenue = avenue;
        robot.street = street;
        robot.beepers = beepers;
        robot.direction = direction;
        this.robots.put(currentRobotId, robot);
        this.update();
        this.trace(robot);
        return currentRobotId;
    }

    int getAvenue(Integer robotId) {
        Robot current = this.getRobot(robotId, false);
        return current.avenue;
    }

    int getStreet(Integer robotId) {
        Robot current = this.getRobot(robotId, false);
        return current.street;
    }

    int getDirection(Integer robotId) {
        Robot current = this.getRobot(robotId, false);
        return current.direction;
    }

    int getBeepers(Integer robotId) {
        Robot current = this.getRobot(robotId, false);
        return current.beepers;
    }

    boolean frontIsClear(Integer robotId) {
        Robot current = this.getRobot(robotId, false);
        Enumeration enumeration = this.walls.elements();
        while (enumeration.hasMoreElements()) {
            Wall currentWall = (Wall)enumeration.nextElement();
            if (!(current.direction == 3 ? currentWall.avenue == current.avenue && currentWall.street == current.street : (current.direction == 1 ? currentWall.avenue == current.avenue && currentWall.street == current.street - 1 : (current.direction == 2 ? currentWall.street == current.street && currentWall.avenue == current.avenue : current.direction == 0 && currentWall.street == current.street - 1 && currentWall.avenue == current.avenue)))) continue;
            return false;
        }
        return true;
    }

    boolean nextToARobot(Integer robotId) {
        Robot current = this.getRobot(robotId, false);
        Enumeration enumeration = this.robots.elements();
        while (enumeration.hasMoreElements()) {
            Robot currentRobot = (Robot)enumeration.nextElement();
            if (current.avenue != currentRobot.avenue || current.street != currentRobot.street || current == currentRobot) continue;
            return true;
        }
        return false;
    }

    boolean nextToABeeper(Integer robotId) {
        Robot current = this.getRobot(robotId, false);
        Enumeration enumeration = this.beepers.elements();
        while (enumeration.hasMoreElements()) {
            Beepers currentBeepers = (Beepers)enumeration.nextElement();
            if (current.avenue != currentBeepers.avenue || current.street != currentBeepers.street) continue;
            return true;
        }
        return false;
    }

    void move(Integer robotId) {
        Robot current = this.getRobot(robotId, true);
        Enumeration enumeration = this.walls.elements();
        switch (current.direction) {
            case 3: {
                while (enumeration.hasMoreElements()) {
                    Wall currentWall = (Wall)enumeration.nextElement();
                    if (currentWall.street != current.street || currentWall.avenue != current.avenue || !currentWall.isEastWest) continue;
                    throw new RuntimeException("Cannot move through wall.");
                }
                ++current.street;
                break;
            }
            case 1: {
                while (enumeration.hasMoreElements()) {
                    Wall currentWall = (Wall)enumeration.nextElement();
                    if (currentWall.street != current.street - 1 || currentWall.avenue != current.avenue || !currentWall.isEastWest) continue;
                    throw new RuntimeException("Cannot move through wall.");
                }
                if (current.street == 1) {
                    throw new RuntimeException("Cannot move through wall.");
                }
                --current.street;
                break;
            }
            case 0: {
                while (enumeration.hasMoreElements()) {
                    Wall currentWall = (Wall)enumeration.nextElement();
                    if (currentWall.avenue != current.avenue - 1 || currentWall.street != current.street || !currentWall.isNorthSouth) continue;
                    throw new RuntimeException("Cannot move through wall.");
                }
                if (current.avenue == 1) {
                    throw new RuntimeException("Cannot move through wall.");
                }
                --current.avenue;
                break;
            }
            case 2: {
                while (enumeration.hasMoreElements()) {
                    Wall currentWall = (Wall)enumeration.nextElement();
                    if (currentWall.avenue != current.avenue || currentWall.street != current.street || !currentWall.isNorthSouth) continue;
                    throw new RuntimeException("Cannot move through wall.");
                }
                ++current.avenue;
            }
        }
        this.trace(current);
        this.update();
    }

    void turnLeft(Integer robotId) {
        Robot current = this.getRobot(robotId, true);
        switch (current.direction) {
            case 3: {
                current.direction = 0;
                break;
            }
            case 1: {
                current.direction = 2;
                break;
            }
            case 0: {
                current.direction = 1;
                break;
            }
            case 2: {
                current.direction = 3;
            }
        }
        this.trace(current);
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pickBeeper(Integer robotId) {
        Robot current = this.getRobot(robotId, true);
        World world = this;
        synchronized (world) {
            Enumeration enumeration = this.beepers.elements();
            while (enumeration.hasMoreElements()) {
                Beepers currentBeepers = (Beepers)enumeration.nextElement();
                if (currentBeepers.street != current.street || currentBeepers.avenue != current.avenue) continue;
                if (currentBeepers.count == 1) {
                    this.beepers.remove(currentBeepers);
                } else {
                    --currentBeepers.count;
                }
                if (current.beepers >= 0) {
                    ++current.beepers;
                }
                this.trace(current);
                this.update();
                return;
            }
        }
        throw new RuntimeException("No beepers to pick up.");
    }

    void putBeeper(Integer robotId) {
        Robot current = this.getRobot(robotId, true);
        if (current.beepers == 0) {
            throw new RuntimeException("Has no beepers.");
        }
        if (current.beepers > 0) {
            --current.beepers;
        }
        World.placeBeepers(current.street, current.avenue, 1);
        this.trace(current);
        this.update();
    }

    void turnOff(Integer robotId) {
        Robot current = this.getRobot(robotId, true);
        current.on = false;
        this.trace(current);
        this.update();
    }

    public static void main(String[] args) throws Exception {
        World world = World.getWorld();
        world.getClass();
        World.setSize(10, 10);
        world.getClass();
        World.placeBeepers(4, 4, 1);
        world.getClass();
        World.placeNSWall(1, 1, 3);
        Integer rob = world.getNewRobot(4, 1, 0, -1);
        world.putBeeper(rob);
        world.turnLeft(rob);
        world.turnLeft(rob);
        world.move(rob);
        world.move(rob);
        world.move(rob);
        world.pickBeeper(rob);
        world.move(rob);
    }

    static {
        World world = new World();
        World.registerWorld(world);
    }

    protected class DelayThread
    extends Thread {
        volatile boolean paused = false;
        boolean doDelay = true;

        public DelayThread() {
        }

        public DelayThread(boolean doDelay) {
            this.doDelay = doDelay;
        }

        public void run() {
            block3: {
                if (!this.doDelay) break block3;
                try {
                    Thread.sleep(World.this.delay);
                    while (this.paused) {
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void pause() {
            this.paused = true;
        }

        public void unPause() {
            this.paused = false;
        }
    }

    protected static class Wall {
        public boolean isEastWest;
        public boolean isNorthSouth;
        public int avenue;
        public int street;

        protected Wall() {
        }
    }

    protected static class Beepers {
        public int avenue;
        public int street;
        public int count;

        protected Beepers() {
        }
    }

    protected static class Robot {
        public int id;
        public boolean on = true;
        public int avenue;
        public int street;
        public int beepers;
        public int direction;

        protected Robot() {
        }

        public String toString() {
            String result = "RobotId " + this.id + " at (street: " + this.street + ") (avenue: " + this.avenue + ") (beepers: ";
            result = this.beepers < 0 ? result + "infinite" : result + this.beepers;
            result = result + ") (direction: ";
            if (this.direction == 3) {
                result = result + "North ";
            } else if (this.direction == 1) {
                result = result + "South ";
            } else if (this.direction == 0) {
                result = result + "West ";
            } else if (this.direction == 2) {
                result = result + "East ";
            }
            result = result + ") ";
            result = this.on ? result + "on" : result + "off";
            return result;
        }
    }
}

