/*
 * Decompiled with CFR 0.152.
 */
package kareltherobot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.Permission;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kareltherobot.World;

public class GUIWorld
extends World {
    private ControlExit security;
    private JFrame jFrame;
    private JTextField streetsText;
    private JTextField avenuesText;
    private JTextField delayText;
    private JButton pauseButton;
    static /* synthetic */ Class class$kareltherobot$World;

    private GUIWorld() {
    }

    private void exitForm(WindowEvent evt) {
        this.security.allowExit();
        System.exit(0);
    }

    private void init() {
        this.security = new ControlExit();
        System.setSecurityManager(this.security);
        this.jFrame = new JFrame();
        this.jFrame.getContentPane().setLayout(new BorderLayout(4, 4));
        this.jFrame.getContentPane().add((Component)new SwingWorld(), "Center");
        this.jFrame.getContentPane().add((Component)this.getSizePanel(), "North");
        this.jFrame.getContentPane().add((Component)this.getDelayPanel(), "South");
        this.jFrame.setForeground(Color.black);
        this.jFrame.setBackground(Color.lightGray);
        this.jFrame.setDefaultCloseOperation(2);
        this.jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GUIWorld.this.exitForm(evt);
            }
        });
        Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = ScreenSize.height * 3 / 4;
        int width = ScreenSize.width * 3 / 4;
        int x = ScreenSize.width / 8;
        int y = ScreenSize.height / 8;
        this.jFrame.show();
        this.jFrame.setSize(new Dimension(width, height));
        this.jFrame.setLocation(x, y);
        this.jFrame.show();
        this.update();
    }

    protected JComponent getSizePanel() {
        JPanel result = new JPanel(new GridLayout(1, 4, 4, 4));
        result.add(new JLabel("streets:"));
        this.streetsText = new JTextField("" + World.numberOfStreets());
        this.streetsText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    World.setStreets(Integer.parseInt(GUIWorld.this.streetsText.getText()));
                }
                catch (NumberFormatException exception) {}
            }
        });
        result.add(this.streetsText);
        result.add(new JLabel("avenues:"));
        this.avenuesText = new JTextField("" + World.numberOfAvenues());
        this.avenuesText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    World.setAvenues(Integer.parseInt(GUIWorld.this.avenuesText.getText()));
                }
                catch (NumberFormatException exception) {}
            }
        });
        result.add(this.avenuesText);
        return result;
    }

    protected JComponent getDelayPanel() {
        JPanel result = new JPanel(new GridLayout(1, 3, 4, 4));
        result.add(new JLabel("delay [ms]:"));
        this.delayText = new JTextField("" + this.delay);
        this.delayText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    World.setDelay(Integer.parseInt(GUIWorld.this.delayText.getText()));
                }
                catch (NumberFormatException exception) {}
            }
        });
        result.add(this.delayText);
        this.pauseButton = new JButton("pause");
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (GUIWorld.this.pauseButton.getText().equals("pause")) {
                    GUIWorld.this.pauseButton.setText("resume");
                    GUIWorld.this.delayThread.pause();
                } else if (GUIWorld.this.pauseButton.getText().equals("resume")) {
                    GUIWorld.this.pauseButton.setText("pause");
                    GUIWorld.this.delayThread.unPause();
                }
            }
        });
        result.add(this.pauseButton);
        return result;
    }

    protected void update() {
        if (this.jFrame != null) {
            this.jFrame.repaint();
        }
    }

    protected void setStreetsInternal(int streets) {
        super.setStreetsInternal(streets);
        if (this.streetsText != null) {
            this.streetsText.setText("" + streets);
        }
    }

    protected void setAvenuesInternal(int avenues) {
        super.setAvenuesInternal(avenues);
        if (this.avenuesText != null) {
            this.avenuesText.setText("" + avenues);
        }
    }

    protected void setDelayInternal(int delay) {
        super.setDelayInternal(delay);
        if (this.delayText != null) {
            this.delayText.setText("" + delay);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GUIWorld world = new GUIWorld();
        if (World.registerWorld(world)) {
            world.init();
        }
    }

    private class SwingWorld
    extends JComponent {
        private Image crossroad;
        private Image[] wallImgs = new Image[4];
        private Image[] beepersImgs = new Image[10];
        private Image[] karel = new Image[4];

        public SwingWorld() {
            this.crossroad = Toolkit.getDefaultToolkit().createImage((class$kareltherobot$World == null ? (class$kareltherobot$World = GUIWorld.class$("kareltherobot.World")) : class$kareltherobot$World).getResource("crossroad.gif"));
            this.beepersImgs[0] = Toolkit.getDefaultToolkit().createImage((class$kareltherobot$World == null ? (class$kareltherobot$World = GUIWorld.class$("kareltherobot.World")) : class$kareltherobot$World).getResource("beepersx.gif"));
            int i = 1;
            while (i <= 9) {
                this.beepersImgs[i] = Toolkit.getDefaultToolkit().createImage((class$kareltherobot$World == null ? GUIWorld.class$("kareltherobot.World") : class$kareltherobot$World).getResource("beepers" + i + ".gif"));
                ++i;
            }
            this.karel[3] = Toolkit.getDefaultToolkit().createImage((class$kareltherobot$World == null ? (class$kareltherobot$World = GUIWorld.class$("kareltherobot.World")) : class$kareltherobot$World).getResource("karelnorth.gif"));
            this.karel[2] = Toolkit.getDefaultToolkit().createImage((class$kareltherobot$World == null ? (class$kareltherobot$World = GUIWorld.class$("kareltherobot.World")) : class$kareltherobot$World).getResource("kareleast.gif"));
            this.karel[1] = Toolkit.getDefaultToolkit().createImage((class$kareltherobot$World == null ? (class$kareltherobot$World = GUIWorld.class$("kareltherobot.World")) : class$kareltherobot$World).getResource("karelsouth.gif"));
            this.karel[0] = Toolkit.getDefaultToolkit().createImage((class$kareltherobot$World == null ? (class$kareltherobot$World = GUIWorld.class$("kareltherobot.World")) : class$kareltherobot$World).getResource("karelwest.gif"));
            this.wallImgs[3] = Toolkit.getDefaultToolkit().createImage((class$kareltherobot$World == null ? (class$kareltherobot$World = GUIWorld.class$("kareltherobot.World")) : class$kareltherobot$World).getResource("wallnorth.gif"));
            this.wallImgs[2] = Toolkit.getDefaultToolkit().createImage((class$kareltherobot$World == null ? (class$kareltherobot$World = GUIWorld.class$("kareltherobot.World")) : class$kareltherobot$World).getResource("walleast.gif"));
            this.wallImgs[1] = Toolkit.getDefaultToolkit().createImage((class$kareltherobot$World == null ? (class$kareltherobot$World = GUIWorld.class$("kareltherobot.World")) : class$kareltherobot$World).getResource("wallsouth.gif"));
            this.wallImgs[0] = Toolkit.getDefaultToolkit().createImage((class$kareltherobot$World == null ? (class$kareltherobot$World = GUIWorld.class$("kareltherobot.World")) : class$kareltherobot$World).getResource("wallwest.gif"));
        }

        public void paint(Graphics g) {
            Object current;
            int avDist = this.getWidth() / (GUIWorld.this.avenues - 1);
            int stDist = this.getHeight() / (GUIWorld.this.streets - 1);
            int a = 0;
            while (a < GUIWorld.this.avenues - 1) {
                int s = 0;
                while (s < GUIWorld.this.streets - 1) {
                    this.drawImage(g, this.crossroad, a, s, avDist, stDist);
                    ++s;
                }
                ++a;
            }
            int a2 = 0;
            while (a2 < GUIWorld.this.avenues) {
                this.drawImage(g, this.wallImgs[1], a2, 0, avDist, stDist);
                ++a2;
            }
            int s = 0;
            while (s < GUIWorld.this.streets) {
                this.drawImage(g, this.wallImgs[0], 0, s, avDist, stDist);
                ++s;
            }
            Enumeration<Object> enumeration = GUIWorld.this.walls.elements();
            while (enumeration.hasMoreElements()) {
                current = (World.Wall)enumeration.nextElement();
                if (((World.Wall)current).isEastWest) {
                    this.drawImage(g, this.wallImgs[3], ((World.Wall)current).avenue - 1, ((World.Wall)current).street - 1, avDist, stDist);
                    continue;
                }
                if (!((World.Wall)current).isNorthSouth) continue;
                this.drawImage(g, this.wallImgs[2], ((World.Wall)current).avenue - 1, ((World.Wall)current).street - 1, avDist, stDist);
            }
            enumeration = GUIWorld.this.beepers.elements();
            while (enumeration.hasMoreElements()) {
                current = (World.Beepers)enumeration.nextElement();
                int index = ((World.Beepers)current).count;
                if (((World.Beepers)current).count > 9) {
                    index = 0;
                }
                this.drawImage(g, this.beepersImgs[index], ((World.Beepers)current).avenue - 1, ((World.Beepers)current).street - 1, avDist, stDist);
            }
            enumeration = GUIWorld.this.robots.elements();
            while (enumeration.hasMoreElements()) {
                current = (World.Robot)enumeration.nextElement();
                this.drawImage(g, this.karel[((World.Robot)current).direction], ((World.Robot)current).avenue - 1, ((World.Robot)current).street - 1, avDist, stDist);
            }
            Toolkit.getDefaultToolkit().sync();
        }

        private void drawImage(Graphics g, Image image, int x, int y, int width, int height) {
            g.drawImage(image, x * width, this.getHeight() - (y + 1) * height, width, height, this);
        }
    }

    private class ControlExit
    extends SecurityManager {
        boolean allowExit = false;

        private ControlExit() {
        }

        public void allowExit() {
            this.allowExit = true;
        }

        public void checkExit(int level) {
            if (!this.allowExit) {
                System.out.println("Forbidden VM exit suppressed.");
                throw new SecurityException();
            }
        }

        public void checkPermission(Permission perm) {
        }

        public void checkPermission(Permission perm, Object context) {
        }
    }
}

