/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.visitors;

import de.cbockisch.jlxf.context.Context;
import de.cbockisch.jlxf.nodes.Node;
import de.cbockisch.jlxf.visitors.Visitor;
import de.cbockisch.jlxf.visitors.VisitorException;
import java.net.URL;
import java.util.Enumeration;

public class PrintTreeVisitor
extends Visitor {
    private int indentWidth;
    private int indent;

    public PrintTreeVisitor(int indentWidth) {
        this.indentWidth = indentWidth;
    }

    public PrintTreeVisitor() {
        this(2);
    }

    public void start(Node node, URL url) throws VisitorException {
        this.indent = 0;
        node.visit(this, null);
    }

    protected void println(String text) {
        int i = 0;
        while (i < this.indent) {
            System.out.print(" ");
            ++i;
        }
        System.out.println(text);
    }

    public void acceptNode(Node node, Context context) throws VisitorException {
        this.println(node.getClass().getName() + " ( " + node.getBeginLine() + ", " + node.getBeginColumn() + " ) - ( " + node.getEndLine() + ", " + node.getEndColumn() + " )");
        Enumeration<Node> enumeration = node.getChildren();
        this.indent += this.indentWidth;
        while (enumeration.hasMoreElements()) {
            Node current = enumeration.nextElement();
            if (current == null) continue;
            current.visit(this, context);
        }
        this.indent -= this.indentWidth;
    }
}

