/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.visitors;

import de.cbockisch.jlxf.context.CompilationUnitContext;
import de.cbockisch.jlxf.context.Context;
import de.cbockisch.jlxf.context.TypeDeclarationContext;
import de.cbockisch.jlxf.nodes.AdditiveExpressionTwoOps;
import de.cbockisch.jlxf.nodes.AndExpressionTwoOps;
import de.cbockisch.jlxf.nodes.Arguments;
import de.cbockisch.jlxf.nodes.ArrayAllocationExpression;
import de.cbockisch.jlxf.nodes.ArrayInitializer;
import de.cbockisch.jlxf.nodes.ArraySelection;
import de.cbockisch.jlxf.nodes.ArrayType;
import de.cbockisch.jlxf.nodes.AssertStatement;
import de.cbockisch.jlxf.nodes.AssignmentOperation;
import de.cbockisch.jlxf.nodes.Block;
import de.cbockisch.jlxf.nodes.BooleanLiteral;
import de.cbockisch.jlxf.nodes.BracketedExpression;
import de.cbockisch.jlxf.nodes.BreakStatement;
import de.cbockisch.jlxf.nodes.CaseSwitchLabel;
import de.cbockisch.jlxf.nodes.CastExpression;
import de.cbockisch.jlxf.nodes.CatchBlock;
import de.cbockisch.jlxf.nodes.CharacterLiteral;
import de.cbockisch.jlxf.nodes.ClassBound;
import de.cbockisch.jlxf.nodes.ClassDeclaration;
import de.cbockisch.jlxf.nodes.ClassNestedClassDeclaration;
import de.cbockisch.jlxf.nodes.ClassNestedInterfaceDeclaration;
import de.cbockisch.jlxf.nodes.ClassOrInterfaceType;
import de.cbockisch.jlxf.nodes.CompilationUnit;
import de.cbockisch.jlxf.nodes.ComplementedUnaryExpression;
import de.cbockisch.jlxf.nodes.ConditionalAndExpressionTwoOps;
import de.cbockisch.jlxf.nodes.ConditionalIfExpression;
import de.cbockisch.jlxf.nodes.ConditionalOrExpressionTwoOps;
import de.cbockisch.jlxf.nodes.ConstructorDeclaration;
import de.cbockisch.jlxf.nodes.ContinueStatement;
import de.cbockisch.jlxf.nodes.DefaultSwitchLabel;
import de.cbockisch.jlxf.nodes.DoStatement;
import de.cbockisch.jlxf.nodes.DotAllocationExpression;
import de.cbockisch.jlxf.nodes.DotClassPrimaryPrefix;
import de.cbockisch.jlxf.nodes.DotIdentifier;
import de.cbockisch.jlxf.nodes.DotThis;
import de.cbockisch.jlxf.nodes.EmptyClassBodyDeclaration;
import de.cbockisch.jlxf.nodes.EmptyInterfaceBodyDeclaration;
import de.cbockisch.jlxf.nodes.EmptyStatement;
import de.cbockisch.jlxf.nodes.EmptyTypeDeclaration;
import de.cbockisch.jlxf.nodes.EqualityExpressionTwoOps;
import de.cbockisch.jlxf.nodes.ExclusiveOrExpressionTwoOps;
import de.cbockisch.jlxf.nodes.ExplicitSuperConstructorInvocation;
import de.cbockisch.jlxf.nodes.ExplicitThisConstructorInvocation;
import de.cbockisch.jlxf.nodes.ExpressionStatement;
import de.cbockisch.jlxf.nodes.FieldDeclaration;
import de.cbockisch.jlxf.nodes.FloatingPointLiteral;
import de.cbockisch.jlxf.nodes.ForStatement;
import de.cbockisch.jlxf.nodes.ForUpdate;
import de.cbockisch.jlxf.nodes.FormalParameter;
import de.cbockisch.jlxf.nodes.Identifier;
import de.cbockisch.jlxf.nodes.IfStatementElse;
import de.cbockisch.jlxf.nodes.IfStatementNoElse;
import de.cbockisch.jlxf.nodes.InclusiveOrExpressionTwoOps;
import de.cbockisch.jlxf.nodes.Initializer;
import de.cbockisch.jlxf.nodes.InstanceOfExpressionTwoOps;
import de.cbockisch.jlxf.nodes.IntegerLiteral;
import de.cbockisch.jlxf.nodes.InterfaceBound;
import de.cbockisch.jlxf.nodes.InterfaceDeclaration;
import de.cbockisch.jlxf.nodes.InterfaceFieldDeclaration;
import de.cbockisch.jlxf.nodes.InterfaceMethodDeclaration;
import de.cbockisch.jlxf.nodes.InterfaceNestedClassDeclaration;
import de.cbockisch.jlxf.nodes.InterfaceNestedInterfaceDeclaration;
import de.cbockisch.jlxf.nodes.LabeledStatement;
import de.cbockisch.jlxf.nodes.LocalVariableDeclaration;
import de.cbockisch.jlxf.nodes.MethodDeclaration;
import de.cbockisch.jlxf.nodes.MultiplicativeExpressionTwoOps;
import de.cbockisch.jlxf.nodes.Node;
import de.cbockisch.jlxf.nodes.NullLiteral;
import de.cbockisch.jlxf.nodes.ObjectAllocationExpression;
import de.cbockisch.jlxf.nodes.Position;
import de.cbockisch.jlxf.nodes.PostfixExpressionAdditive;
import de.cbockisch.jlxf.nodes.PrefixExpression;
import de.cbockisch.jlxf.nodes.PrimaryExpression;
import de.cbockisch.jlxf.nodes.PrimitiveType;
import de.cbockisch.jlxf.nodes.RelationalExpressionTwoOps;
import de.cbockisch.jlxf.nodes.ReturnStatement;
import de.cbockisch.jlxf.nodes.ShiftExpressionTwoOps;
import de.cbockisch.jlxf.nodes.SignedUnaryExpression;
import de.cbockisch.jlxf.nodes.StatementExpression;
import de.cbockisch.jlxf.nodes.StatementExpressionList;
import de.cbockisch.jlxf.nodes.StringLiteral;
import de.cbockisch.jlxf.nodes.SuperPrimaryPrefix;
import de.cbockisch.jlxf.nodes.SwitchBlock;
import de.cbockisch.jlxf.nodes.SwitchStatement;
import de.cbockisch.jlxf.nodes.SynchronizedStatement;
import de.cbockisch.jlxf.nodes.ThisPrimaryPrefix;
import de.cbockisch.jlxf.nodes.ThrowStatement;
import de.cbockisch.jlxf.nodes.TryStatement;
import de.cbockisch.jlxf.nodes.TypeParameter;
import de.cbockisch.jlxf.nodes.TypeVariable;
import de.cbockisch.jlxf.nodes.UnqualifiedTypeIdentifier;
import de.cbockisch.jlxf.nodes.VariableDeclarationForInit;
import de.cbockisch.jlxf.nodes.VariableDeclarator;
import de.cbockisch.jlxf.nodes.VoidResultType;
import de.cbockisch.jlxf.nodes.WhileStatement;
import de.cbockisch.jlxf.visitors.Visitor;
import de.cbockisch.jlxf.visitors.VisitorException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrintVisitor
extends Visitor {
    private PrintWriter output;
    private int indentWidth;
    private int indent;
    private int line;
    private int pos;

    public PrettyPrintVisitor(PrintWriter output, int indentWidth) {
        this.output = output;
        this.indentWidth = indentWidth;
    }

    private void print(String text) {
        int lastNLPos = -1;
        int nlPos = -1;
        while ((nlPos = text.indexOf("\n", nlPos + 1)) != -1) {
            ++this.line;
            this.pos = 0;
            lastNLPos = nlPos;
        }
        this.pos = lastNLPos == -1 ? (this.pos += text.length()) : (this.pos += text.length() - lastNLPos);
        this.output.print(text);
    }

    private void println(String text) {
        this.print(new StringBuffer().append(text).append("\n").toString());
    }

    @Override
    public void acceptNode(Node node, Context context) throws VisitorException {
        this.print(new StringBuffer().append("/*").append(node.getClass().getName()).append("*/").toString());
        Enumeration<Node> enumeration = node.getChildren();
        while (enumeration.hasMoreElements()) {
            Node current = enumeration.nextElement();
            if (current == null) continue;
            current.visit(this, context);
        }
    }

    @Override
    public void start(Node node, URL url) throws VisitorException {
        CompilationUnitContext cuContext = new CompilationUnitContext(url);
        try {
            cuContext.setDefinition(node);
        }
        catch (Exception exception) {
            VisitorException visitorException = new VisitorException(new StringBuffer().append("Could not create CompilationUnit context for PrettyPrintVisitor for file ").append(url).toString());
            visitorException.initCause(exception);
            throw visitorException;
        }
        this.indent = 0;
        this.line = 1;
        this.pos = 1;
        node.visit(this, cuContext);
        this.output.flush();
    }

    protected void printIndented(String text) {
        int i = 0;
        while (i < this.indent) {
            this.print(" ");
            ++i;
        }
        this.print(text);
    }

    protected void printlnIndented(String text) {
        int i = 0;
        while (i < this.indent) {
            this.print(" ");
            ++i;
        }
        this.println(text);
    }

    protected <T extends Node> void visit(Vector<T> nodes, Context context) throws VisitorException {
        this.visit("", "", "", nodes, context);
    }

    protected <T extends Node> void visit(String leadIn, String leadOut, String sep, Vector<T> nodes, Context context) throws VisitorException {
        if (!nodes.isEmpty()) {
            this.print(leadIn);
            Enumeration<T> enumeration = nodes.elements();
            while (enumeration.hasMoreElements()) {
                ((Node)enumeration.nextElement()).visit(this, context);
                if (!enumeration.hasMoreElements()) continue;
                this.print(sep);
            }
            this.print(leadOut);
        }
    }

    protected void visit(Node node, Context context) throws VisitorException {
        this.visit("", "", node, context);
    }

    protected void visit(String leadIn, String leadOut, Node node, Context context) throws VisitorException {
        if (node != null) {
            this.print(leadIn);
            node.visit(this, context);
            this.print(leadOut);
        }
    }

    protected void indent() {
        this.indent += this.indentWidth;
    }

    protected void outdent() {
        this.indent -= this.indentWidth;
    }

    protected String getSpaces() {
        String result = new String();
        int i = 0;
        while (i < this.indent) {
            result = new StringBuffer().append(result).append(" ").toString();
            ++i;
        }
        return result;
    }

    @Override
    public void acceptCompilationUnit(CompilationUnit node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        if (node.getPackageName() != null) {
            this.printlnIndented(new StringBuffer().append("package ").append(node.getPackageName()).append(";\n").toString());
        }
        Enumeration<String> imports = node.getImportNames().elements();
        while (imports.hasMoreElements()) {
            this.printlnIndented(new StringBuffer().append("import ").append(imports.nextElement()).append(";").toString());
            if (imports.hasMoreElements()) continue;
            this.println("");
        }
        this.visit("", "", "\n\n\n", node.getTypeDeclarations(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptEmptyTypeDeclaration(EmptyTypeDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printlnIndented(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptClassDeclaration(ClassDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        TypeDeclarationContext newContext = new TypeDeclarationContext();
        try {
            ((Context)newContext).setDefinition(node);
            ((Context)newContext).setParentContext(context);
        }
        catch (Exception exception) {
            VisitorException visitorException = new VisitorException(new StringBuffer().append("Could not create TypeDeclaration context for PrettyPrintVisitor for type ").append(node.getName()).append(" within context ").append(context).toString());
            visitorException.initCause(exception);
            throw visitorException;
        }
        this.printIndented("");
        if (node.getModifiers() != 0) {
            this.print(new StringBuffer().append(Modifier.toString(node.getModifiers())).append(" ").toString());
        }
        this.print(new StringBuffer().append("class ").append(node.getName()).toString());
        this.visit("< ", " >", ", ", node.getTypeParameters(), newContext);
        this.println("");
        this.indent();
        this.visit("extends ", "\n", node.getSuperType(), newContext);
        this.outdent();
        this.indent();
        this.visit("implements ", "\n", ", ", node.getSuperInterfaces(), newContext);
        this.outdent();
        this.printIndented("{");
        this.indent();
        this.visit("\n\n\n", "\n\n", "\n\n", node.getClassBodyDeclarations(), newContext);
        this.outdent();
        this.printIndented("}");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptClassNestedClassDeclaration(ClassNestedClassDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getClassDeclaration(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptClassNestedInterfaceDeclaration(ClassNestedInterfaceDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getInterfaceDeclaration(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptInitializer(Initializer node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        if (node.getModifiers() != 0) {
            this.printlnIndented(Modifier.toString(node.getModifiers()));
        }
        this.visit(node.getBlock(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptConstructorDeclaration(ConstructorDeclaration node, Context context) throws VisitorException {
        String className;
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("");
        if (node.getModifiers() != 0) {
            this.print(new StringBuffer().append(Modifier.toString(node.getModifiers())).append(" ").toString());
        }
        if ((className = context.getName()).lastIndexOf(".") >= 0) {
            className = className.substring(className.lastIndexOf(".") + 1);
        }
        this.print(new StringBuffer().append(className).append("(").toString());
        this.visit(" ", " ", ", ", node.getFormalParameters(), context);
        this.print(")");
        this.indent();
        this.visit("\nthrows ", "", ", ", node.getExceptions(), context);
        this.outdent();
        this.println("");
        this.visit(node.getBlock(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptFormalParameter(FormalParameter node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        if (node.getModifiers() != 0) {
            this.print(new StringBuffer().append(Modifier.toString(node.getModifiers())).append(" ").toString());
        }
        this.visit(node.getType(), context);
        this.print(new StringBuffer().append(" ").append(node.getVariableId()).toString());
        int i = 0;
        while (i < node.getDimension()) {
            this.print("[]");
            ++i;
        }
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptExplicitThisConstructorInvocation(ExplicitThisConstructorInvocation node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print("this(");
        this.visit(" ", " ", ", ", node.getArguments(), context);
        this.println(");");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptExplicitSuperConstructorInvocation(ExplicitSuperConstructorInvocation node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("");
        this.visit("", ".", node.getPrimaryExpression(), context);
        this.print("super(");
        this.visit(" ", " ", ", ", node.getArguments(), context);
        this.println(");");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptMethodDeclaration(MethodDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("");
        if (node.getModifiers() != 0) {
            this.print(new StringBuffer().append(Modifier.toString(node.getModifiers())).append(" ").toString());
        }
        this.visit("< ", " > ", ", ", node.getTypeParameters(), context);
        this.visit(node.getResultType(), context);
        this.print(new StringBuffer().append(" ").append(node.getName()).append("(").toString());
        this.visit(" ", " ", ", ", node.getFormalParameters(), context);
        this.print(")");
        int i = 0;
        while (i < node.getArrayDimension()) {
            this.print("[]");
            ++i;
        }
        this.indent();
        this.visit("\nthrows ", "", ", ", node.getExceptions(), context);
        this.outdent();
        if (Modifier.isAbstract(node.getModifiers())) {
            this.println(";");
        } else {
            this.println("");
            this.visit(node.getBlock(), context);
        }
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptFieldDeclaration(FieldDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("");
        if (node.getModifiers() != 0) {
            this.print(new StringBuffer().append(Modifier.toString(node.getModifiers())).append(" ").toString());
        }
        this.visit("", " ", node.getType(), context);
        this.visit("", "", ", ", node.getVariableDeclarators(), context);
        this.println(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptVariableDeclarator(VariableDeclarator node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(node.getVariableId());
        int i = 0;
        while (i < node.getDimension()) {
            this.print("[]");
            ++i;
        }
        this.visit(" = ", "", node.getVariableInitializer(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptArrayInitializer(ArrayInitializer node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit("{ ", " }", ", ", node.getVariableInitializers(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptEmptyClassBodyDeclaration(EmptyClassBodyDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printlnIndented(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptInterfaceDeclaration(InterfaceDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        TypeDeclarationContext newContext = new TypeDeclarationContext();
        try {
            ((Context)newContext).setDefinition(node);
            ((Context)newContext).setParentContext(context);
        }
        catch (Exception exception) {
            VisitorException visitorException = new VisitorException(new StringBuffer().append("Could not create TypeDeclaration context for PrettyPrintVisitor for type ").append(node.getName()).append(" within context ").append(context).toString());
            visitorException.initCause(exception);
            throw visitorException;
        }
        this.printIndented("");
        if (node.getModifiers() != 0) {
            this.print(new StringBuffer().append(Modifier.toString(node.getModifiers())).append(" ").toString());
        }
        this.print(new StringBuffer().append("interface ").append(node.getName()).toString());
        this.visit("< ", " >", ", ", node.getTypeParameters(), newContext);
        this.println("");
        this.indent();
        this.visit("extends ", "", ", ", node.getSuperTypes(), newContext);
        this.outdent();
        this.printIndented("{");
        this.indent();
        this.visit("\n\n\n", "\n\n", "\n\n", node.getInterfaceBodyDeclarations(), newContext);
        this.outdent();
        this.printIndented("}");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptInterfaceNestedClassDeclaration(InterfaceNestedClassDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getClassDeclaration(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptInterfaceNestedInterfaceDeclaration(InterfaceNestedInterfaceDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getInterfaceDeclaration(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptInterfaceMethodDeclaration(InterfaceMethodDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getMethodDeclaration(), context);
        this.print(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptInterfaceFieldDeclaration(InterfaceFieldDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getFieldDeclaration(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptEmptyInterfaceBodyDeclaration(EmptyInterfaceBodyDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printlnIndented(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptTypeParameter(TypeParameter node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(node.getIdentifier());
        this.visit(" ", "", node.getTypeBound(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptClassBound(ClassBound node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit("extends ", "", node.getType(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptInterfaceBound(InterfaceBound node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit("implements ", "", node.getType(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptArrayType(ArrayType node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getComponentType(), context);
        int i = 0;
        while (i < node.getDimension()) {
            this.print("[]");
            ++i;
        }
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptTypeVariable(TypeVariable node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(node.getIdentifier());
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptClassOrInterfaceType(ClassOrInterfaceType node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit("", "", ".", node.getUnqualifiedTypeIdentifiers(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptUnqualifiedTypeIdentifier(UnqualifiedTypeIdentifier node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(node.getIdentifier());
        this.visit("< ", " >", ", ", node.getTypeArguments(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptPrimitiveType(PrimitiveType node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(node.getType());
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptVoidResultType(VoidResultType node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print("void");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptAssignmentOperation(AssignmentOperation node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLeftOperand(), context);
        this.print(new StringBuffer().append(" ").append(node.getAssignmentOperator()).append(" ").toString());
        this.visit(node.getRightOperand(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptConditionalIfExpression(ConditionalIfExpression node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getCondition(), context);
        this.print(" ? ");
        this.visit(node.getThenExpression(), context);
        this.print(" : ");
        this.visit(node.getElseExpression(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptConditionalOrExpressionTwoOps(ConditionalOrExpressionTwoOps node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLeftOperand(), context);
        this.print(" || ");
        this.visit(node.getRightOperand(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptConditionalAndExpressionTwoOps(ConditionalAndExpressionTwoOps node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLeftOperand(), context);
        this.print(" && ");
        this.visit(node.getRightOperand(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptInclusiveOrExpressionTwoOps(InclusiveOrExpressionTwoOps node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLeftOperand(), context);
        this.print(" | ");
        this.visit(node.getRightOperand(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptExclusiveOrExpressionTwoOps(ExclusiveOrExpressionTwoOps node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLeftOperand(), context);
        this.print(" ^ ");
        this.visit(node.getRightOperand(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptAndExpressionTwoOps(AndExpressionTwoOps node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLeftOperand(), context);
        this.print(" & ");
        this.visit(node.getRightOperand(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptEqualityExpressionTwoOps(EqualityExpressionTwoOps node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLeftOperand(), context);
        this.print(new StringBuffer().append(" ").append(node.getEqualityOperator()).append(" ").toString());
        this.visit(node.getRightOperand(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptInstanceOfExpressionTwoOps(InstanceOfExpressionTwoOps node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getInstanceOfExpression(), context);
        this.print(" instanceof ");
        this.visit(node.getType(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptRelationalExpressionTwoOps(RelationalExpressionTwoOps node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLeftOperand(), context);
        this.print(new StringBuffer().append(" ").append(node.getRelationalOperator()).append(" ").toString());
        this.visit(node.getRightOperand(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptShiftExpressionTwoOps(ShiftExpressionTwoOps node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLeftOperand(), context);
        this.print(new StringBuffer().append(" ").append(node.getShiftOperator()).append(" ").toString());
        this.visit(node.getRightOperand(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptAdditiveExpressionTwoOps(AdditiveExpressionTwoOps node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLeftOperand(), context);
        this.print(new StringBuffer().append(" ").append(node.getAdditiveOperator()).append(" ").toString());
        this.visit(node.getRightOperand(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptMultiplicativeExpressionTwoOps(MultiplicativeExpressionTwoOps node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLeftOperand(), context);
        this.print(new StringBuffer().append(" ").append(node.getMultiplicativeOperator()).append(" ").toString());
        this.visit(node.getRightOperand(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptSignedUnaryExpression(SignedUnaryExpression node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(node.getSign());
        this.visit(node.getUnaryExpression(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptPrefixExpression(PrefixExpression node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(node.getPrefixOperator());
        this.visit(node.getPrimaryExpression(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptComplementedUnaryExpression(ComplementedUnaryExpression node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(node.getComplementOperator());
        this.visit(node.getUnaryExpression(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptPostfixExpressionAdditive(PostfixExpressionAdditive node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getPrimaryExpression(), context);
        this.print(node.getPostfixOperator());
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptCastExpression(CastExpression node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit("(", ") ", node.getTargetType(), context);
        this.visit(node.getUnaryExpression(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptPrimaryExpression(PrimaryExpression node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getPrimaryPrefix(), context);
        this.visit(node.getPrimarySuffixs(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptThisPrimaryPrefix(ThisPrimaryPrefix node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print("this");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptSuperPrimaryPrefix(SuperPrimaryPrefix node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(new StringBuffer().append("super.").append(node.getIdentifier()).toString());
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptBracketedExpression(BracketedExpression node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit("( ", " )", node.getExpression(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptDotClassPrimaryPrefix(DotClassPrimaryPrefix node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getResultType(), context);
        this.print(".class");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptIdentifier(Identifier node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit("< ", " > ", ", ", node.getTypeArguments(), context);
        this.print(node.getName());
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptDotThis(DotThis node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(".this");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptDotAllocationExpression(DotAllocationExpression node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(".");
        this.visit(node.getAllocationExpression(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptArraySelection(ArraySelection node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit("[", "]", node.getIndex(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptDotIdentifier(DotIdentifier node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(new StringBuffer().append(".").append(node.getIdentifier()).toString());
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptIntegerLiteral(IntegerLiteral node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(new StringBuffer().append("").append(node.getValue()).toString());
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptFloatingPointLiteral(FloatingPointLiteral node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(new StringBuffer().append("").append(node.getValue()).toString());
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptCharacterLiteral(CharacterLiteral node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print("'");
        this.print(node.getValue());
        this.print("'");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptStringLiteral(StringLiteral node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print("\"");
        this.print(node.getValue());
        this.print("\"");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptBooleanLiteral(BooleanLiteral node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print(new StringBuffer().append("").append(node.getValue()).toString());
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptNullLiteral(NullLiteral node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print("null");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptArguments(Arguments node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print("(");
        this.visit(" ", " ", ", ", node.getArguments(), context);
        this.print(")");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptArrayAllocationExpression(ArrayAllocationExpression node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print("new ");
        this.visit(node.getType(), context);
        this.visit("[", "]", "][", node.getBounds(), context);
        int i = 0;
        while (i < node.getAdditionalDimension()) {
            this.print("[]");
            ++i;
        }
        this.visit(node.getArrayInitializer(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptObjectAllocationExpression(ObjectAllocationExpression node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.print("new ");
        this.visit(node.getClassOrInterfaceType(), context);
        this.print("(");
        this.visit(" ", " ", ", ", node.getArguments(), context);
        this.print(")");
        if (!node.getClassBodyDeclarations().isEmpty()) {
            this.println("");
            this.printlnIndented("{");
            this.indent();
            this.visit(node.getClassBodyDeclarations(), context);
            this.outdent();
            this.printlnIndented("}");
        }
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptLabeledStatement(LabeledStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.println(new StringBuffer().append(node.getLabel()).append(":").toString());
        this.visit(node.getStatement(), context);
        this.println(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptBlock(Block node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printlnIndented("{");
        this.indent();
        this.visit("", "", "", node.getBlockStatements(), context);
        this.outdent();
        this.printlnIndented("}");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptLocalVariableDeclaration(LocalVariableDeclaration node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        if (node.getModifiers() != 0) {
            this.print(new StringBuffer().append(Modifier.toString(node.getModifiers())).append(" ").toString());
        }
        this.visit(node.getType(), context);
        this.visit(" ", "", ", ", node.getVariableDeclarators(), context);
        this.print(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptEmptyStatement(EmptyStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printlnIndented(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptStatementExpression(StatementExpression node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getExpression(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptExpressionStatement(ExpressionStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("");
        this.visit(node.getStatementExpression(), context);
        this.println(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptSwitchStatement(SwitchStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("switch( ");
        this.visit(node.getExpression(), context);
        this.println(" )");
        this.printlnIndented("{");
        this.indent();
        this.visit(this.getSpaces(), "\n", new StringBuffer().append("\n").append(this.getSpaces()).toString(), node.getSwitchBlocks(), context);
        this.outdent();
        this.printlnIndented("}");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptSwitchBlock(SwitchBlock node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getSwitchLabel(), context);
        this.visit("", "", ";\n", node.getBlockStatements(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptCaseSwitchLabel(CaseSwitchLabel node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("case ");
        this.visit(node.getExpression(), context);
        this.printlnIndented(" : ");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptDefaultSwitchLabel(DefaultSwitchLabel node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printlnIndented("default :");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptIfStatementNoElse(IfStatementNoElse node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("if( ");
        this.visit(node.getExpression(), context);
        this.println(" )");
        this.indent();
        this.visit(node.getThenStatement(), context);
        this.outdent();
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptIfStatementElse(IfStatementElse node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("if( ");
        this.visit(node.getExpression(), context);
        this.println(" )");
        this.indent();
        this.visit(node.getThenStatement(), context);
        this.outdent();
        this.printlnIndented("else");
        this.indent();
        this.visit(node.getElseStatement(), context);
        this.outdent();
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptWhileStatement(WhileStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("while( ");
        this.visit(node.getExpression(), context);
        this.println(" )");
        this.indent();
        this.visit(node.getStatement(), context);
        this.outdent();
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptDoStatement(DoStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printlnIndented("do");
        this.indent();
        this.visit(node.getStatement(), context);
        this.outdent();
        this.printIndented("while( ");
        this.visit(node.getExpression(), context);
        this.println(" );");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptForStatement(ForStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("for( ");
        this.visit(" ", "", node.getForInit(), context);
        if (node.getForInit() == null || node.getForInit() instanceof StatementExpressionList) {
            this.print(";");
        }
        this.visit(" ", "", node.getForCondition(), context);
        this.print(";");
        this.visit(" ", " ", node.getForUpdate(), context);
        this.println(")");
        this.indent();
        this.visit(node.getStatement(), context);
        this.outdent();
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptVariableDeclarationForInit(VariableDeclarationForInit node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit(node.getLocalVariableDeclaration(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptStatementExpressionList(StatementExpressionList node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit("", "", ", ", node.getStatementExpressions(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptForUpdate(ForUpdate node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.visit("", "", ", ", node.getStatementExpressions(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptBreakStatement(BreakStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("break");
        if (node.getLabel() != null) {
            this.print(new StringBuffer().append(" ").append(node.getLabel()).toString());
        }
        this.println(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptContinueStatement(ContinueStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("continue");
        if (node.getLabel() != null) {
            this.print(new StringBuffer().append(" ").append(node.getLabel()).toString());
        }
        this.println(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptReturnStatement(ReturnStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("return");
        this.visit(" ", "", node.getExpression(), context);
        this.println(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptThrowStatement(ThrowStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("throw ");
        this.visit(node.getExpression(), context);
        this.println(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptSynchronizedStatement(SynchronizedStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("synchronized( ");
        this.visit(node.getExpression(), context);
        this.println(" )");
        this.visit(node.getBlock(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptTryStatement(TryStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printlnIndented("try");
        this.visit(node.getTryBlock(), context);
        this.visit(node.getCatchBlocks(), context);
        this.visit(new StringBuffer().append("\n").append(this.getSpaces()).append("finally\n").toString(), "", node.getFinallyBlock(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptCatchBlock(CatchBlock node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("catch( ");
        this.visit(node.getFormalParameter(), context);
        this.println(" )");
        this.visit(node.getBlock(), context);
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }

    @Override
    public void acceptAssertStatement(AssertStatement node, Context context) throws VisitorException {
        Position genPos = new Position();
        genPos.setStartPos(this.line, this.pos);
        this.printIndented("assert ");
        this.visit(node.getAssertionExpression(), context);
        this.visit(" : ", "", node.getAssertionName(), context);
        this.println(";");
        node.setData("genPos", genPos.setEndPos(this.line, this.pos));
    }
}

