/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.visitors;

import de.cbockisch.jlxf.GJavaParser;
import de.cbockisch.jlxf.context.CompilationUnitContext;
import de.cbockisch.jlxf.context.Context;
import de.cbockisch.jlxf.context.IllegalContextException;
import de.cbockisch.jlxf.context.IllegalNodeTypeException;
import de.cbockisch.jlxf.execution.Option;
import de.cbockisch.jlxf.nodes.ArrayAllocationExpression;
import de.cbockisch.jlxf.nodes.ArraySelection;
import de.cbockisch.jlxf.nodes.ArrayType;
import de.cbockisch.jlxf.nodes.ClassBodyDeclaration;
import de.cbockisch.jlxf.nodes.ClassDeclaration;
import de.cbockisch.jlxf.nodes.ClassOrInterfaceType;
import de.cbockisch.jlxf.nodes.CompilationUnit;
import de.cbockisch.jlxf.nodes.ConditionalAndExpressionTwoOps;
import de.cbockisch.jlxf.nodes.ConstructorDeclaration;
import de.cbockisch.jlxf.nodes.ForStatement;
import de.cbockisch.jlxf.nodes.FormalParameter;
import de.cbockisch.jlxf.nodes.LoopStatement;
import de.cbockisch.jlxf.nodes.MethodDeclaration;
import de.cbockisch.jlxf.nodes.Node;
import de.cbockisch.jlxf.nodes.PrimitiveType;
import de.cbockisch.jlxf.nodes.ReferenceType;
import de.cbockisch.jlxf.nodes.RelationalExpressionTwoOps;
import de.cbockisch.jlxf.nodes.TaskDeclaration;
import de.cbockisch.jlxf.nodes.Type;
import de.cbockisch.jlxf.nodes.TypeVariable;
import de.cbockisch.jlxf.nodes.UnqualifiedTypeIdentifier;
import de.cbockisch.jlxf.nodes.VariableDeclarator;
import de.cbockisch.jlxf.util.Iterator;
import de.cbockisch.jlxf.util.TypeInfo;
import de.cbockisch.jlxf.visitors.Visitor;
import de.cbockisch.jlxf.visitors.VisitorException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KarelJ2JavaVisitor
extends Visitor {
    static int index = 0;

    @Override
    public void acceptNode(Node node, Context context) throws VisitorException {
        Iterator it = node.getIterator();
        while (it.hasNext()) {
            GJavaParser parser;
            Node current = it.getNext();
            current.visit(this, context);
            if (current instanceof LoopStatement) {
                try {
                    LoopStatement loopStatement = (LoopStatement)current;
                    parser = GJavaParser.getParser(new StringBuffer().append("for( int _i").append(index).append(" = 0; _i").append(index).append(" < 0; _i").append(index).append("++ );").toString());
                    parser.getClass();
                    ForStatement forStatement = GJavaParser.ForStatement();
                    ((RelationalExpressionTwoOps)forStatement.getForCondition()).setRightOperand(loopStatement.getShiftExpression());
                    forStatement.setStatement(loopStatement.getStatement());
                    ++index;
                    it.replace(forStatement);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!(current instanceof TaskDeclaration)) continue;
            try {
                TaskDeclaration taskDeclaration = (TaskDeclaration)current;
                parser = GJavaParser.getParser("public class KarelTask implements Directions{public static void main( String args[] ) {}}");
                parser.getClass();
                ClassDeclaration classDeclaration = GJavaParser.ClassDeclaration();
                MethodDeclaration methodDeclaration = (MethodDeclaration)classDeclaration.getClassBodyDeclarations().firstElement();
                methodDeclaration.setBlock(taskDeclaration.getBlock());
                it.replace(classDeclaration);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void start(Node node, URL url) throws IllegalNodeTypeException, IllegalContextException, VisitorException {
        index = 0;
        CompilationUnitContext cuContext = new CompilationUnitContext(url);
        try {
            cuContext.setDefinition(node);
        }
        catch (Exception exception) {
            VisitorException visitorException = new VisitorException(new StringBuffer().append("Could not create CompilationUnit context for PrettyPrintVisitor for file ").append(url).toString());
            visitorException.initCause(exception);
            throw visitorException;
        }
        node.visit(this, cuContext);
    }

    @Override
    public Enumeration<Option> getOptions() {
        return new Vector().elements();
    }

    private String getTypeName(Type type) {
        if (type instanceof ReferenceType) {
            return this.getTypeName((ReferenceType)type);
        }
        if (type instanceof PrimitiveType) {
            return this.getTypeName((PrimitiveType)type);
        }
        return null;
    }

    private String getTypeName(ReferenceType type) {
        if (type instanceof ClassOrInterfaceType) {
            return this.getTypeName((ClassOrInterfaceType)type);
        }
        if (type instanceof ArrayType) {
            return this.getTypeName((ArrayType)type);
        }
        if (type instanceof TypeVariable) {
            return this.getTypeName((TypeVariable)type);
        }
        return null;
    }

    private String getTypeName(ClassOrInterfaceType type) {
        String result = null;
        Enumeration<UnqualifiedTypeIdentifier> typeIds = type.getUnqualifiedTypeIdentifiers().elements();
        while (typeIds.hasMoreElements()) {
            UnqualifiedTypeIdentifier current = typeIds.nextElement();
            result = result == null ? current.getIdentifier() : new StringBuffer().append(result).append(".").append(current.getIdentifier()).toString();
            Enumeration<ReferenceType> typeArgs = current.getTypeArguments().elements();
            if (!typeArgs.hasMoreElements()) continue;
            result = new StringBuffer().append(result).append("<").toString();
            while (typeArgs.hasMoreElements()) {
                result = new StringBuffer().append(result).append(this.getTypeName(typeArgs.nextElement())).toString();
                if (!typeArgs.hasMoreElements()) continue;
                result = new StringBuffer().append(result).append(", ").toString();
            }
            result = new StringBuffer().append(result).append(">").toString();
        }
        return result;
    }

    private String getTypeName(ArrayType type) {
        String result = this.getTypeName(type.getComponentType());
        int i = 0;
        while (i < type.getDimension()) {
            result = new StringBuffer().append(result).append("[]").toString();
            ++i;
        }
        return result;
    }

    private String getTypeName(TypeVariable type) {
        return type.getIdentifier();
    }

    private String getTypeName(PrimitiveType type) {
        return type.getType();
    }

    @Override
    public void acceptCompilationUnit(CompilationUnit node, Context context) throws VisitorException {
        node.addImportName("kareltherobot.*");
        CompilationUnitContext cuContext = new CompilationUnitContext(context.getUrl());
        try {
            cuContext.setDefinition(node);
        }
        catch (Exception exception) {
            VisitorException visitorException = new VisitorException(new StringBuffer().append("Could not create CompilationUnit context for PrettyPrintVisitor for file ").append(context.getUrl()).toString());
            visitorException.initCause(exception);
            throw visitorException;
        }
        this.acceptNode(node, cuContext);
    }

    @Override
    public void acceptClassDeclaration(ClassDeclaration node, Context context) throws VisitorException {
        boolean addConsts = true;
        Enumeration<ReferenceType> interfaces = node.getSuperInterfaces().elements();
        while (interfaces.hasMoreElements()) {
            String superInterface = this.getTypeName(interfaces.nextElement());
            if (!superInterface.equals("Directions") && !superInterface.equals("kareltherobot.Directions")) continue;
            addConsts = false;
            break;
        }
        if (addConsts) {
            UnqualifiedTypeIdentifier typeId = new UnqualifiedTypeIdentifier();
            typeId.setIdentifier("Directions");
            ClassOrInterfaceType type = new ClassOrInterfaceType();
            type.addUnqualifiedTypeIdentifier(typeId);
            node.addSuperInterface(type);
        }
        Vector<ConstructorDeclaration> thisConstructors = new Vector<ConstructorDeclaration>();
        Enumeration<ClassBodyDeclaration> classBodyDecls = node.getClassBodyDeclarations().elements();
        boolean addKarelConstructor = true;
        while (classBodyDecls.hasMoreElements()) {
            ClassBodyDeclaration current = classBodyDecls.nextElement();
            if (!(current instanceof ConstructorDeclaration)) continue;
            thisConstructors.add((ConstructorDeclaration)current);
            Vector<FormalParameter> parameters = ((ConstructorDeclaration)current).getFormalParameters();
            if (parameters.size() != 4 || !this.getTypeName(parameters.elementAt(0).getType()).equals("int") || !this.getTypeName(parameters.elementAt(1).getType()).equals("int") || !this.getTypeName(parameters.elementAt(2).getType()).equals("int") || !this.getTypeName(parameters.elementAt(3).getType()).equals("int")) continue;
            addKarelConstructor = false;
        }
        if (addKarelConstructor) {
            boolean reallyAddKarelConstructor = false;
            context.getClass();
            TypeInfo superType = Context.getTypeInfo(this.getTypeName(node.getSuperType()), context);
            while (superType != null && superType.getFileInfo().isSource() && !superType.getQualifiedName().equals("kareltherobot.ur_Robot")) {
                CompilationUnitContext cuContext = new CompilationUnitContext(superType.getFileInfo().getUrl());
                try {
                    cuContext.setDefinition(superType.getFileInfo().getCompilationUnit());
                    superType = Context.getTypeInfo(this.getTypeName(((ClassDeclaration)superType.getDefinition()).getSuperType()), cuContext);
                }
                catch (IllegalNodeTypeException exception) {
                    superType = null;
                }
            }
            if (superType != null && superType.getQualifiedName().equals("kareltherobot.ur_Robot")) {
                reallyAddKarelConstructor = true;
            }
            if (superType != null && !superType.getFileInfo().isSource()) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(superType.getQualifiedName());
                }
                catch (ClassNotFoundException exception) {}
                while (clazz != null && !clazz.getName().equals("kareltherobot.ur_Robot")) {
                    clazz = clazz.getSuperclass();
                }
                if (clazz != null && clazz.getName().equals("kareltherobot.ur_Robot")) {
                    reallyAddKarelConstructor = true;
                }
            }
            if (reallyAddKarelConstructor) {
                try {
                    GJavaParser parser = GJavaParser.getParser(new StringBuffer().append("public ").append(node.getName()).append("( int street, int avenue, int direction, int beepers ) { super( street, avenue, direction, beepers ); }").toString());
                    parser.getClass();
                    ConstructorDeclaration constructorDeclaration = GJavaParser.ConstructorDeclaration();
                    node.addClassBodyDeclaration(constructorDeclaration);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.acceptTypeDeclaration(node, context);
    }

    @Override
    public void acceptMethodDeclaration(MethodDeclaration node, Context context) throws VisitorException {
        if (node.getArrayDimension() > 0) {
            System.err.println(new StringBuffer().append(context.getUrl()).append(":").append(node.getBeginLine()).append(",").append(node.getBeginColumn()).append(": Warning: array used").toString());
        }
        if (!(Modifier.isPublic(node.getModifiers()) || Modifier.isProtected(node.getModifiers()) || Modifier.isPrivate(node.getModifiers()))) {
            node.setModifiers(node.getModifiers() | 1);
        }
        this.acceptClassBodyDeclaration(node, context);
    }

    @Override
    public void acceptForStatement(ForStatement node, Context context) throws VisitorException {
        System.err.println(new StringBuffer().append(context.getUrl()).append(":").append(node.getBeginLine()).append(",").append(node.getBeginColumn()).append(": Warning: for-statement used").toString());
        this.acceptStatement(node, context);
    }

    @Override
    public void acceptConditionalAndExpressionTwoOps(ConditionalAndExpressionTwoOps node, Context context) throws VisitorException {
        System.err.println(new StringBuffer().append(context.getUrl()).append(":").append(node.getBeginLine()).append(",").append(node.getBeginColumn()).append(": Warning: && used").toString());
        this.acceptConditionalAndExpression(node, context);
    }

    public void acceptConditionalOrExpressionTwoOps(ConditionalAndExpressionTwoOps node, Context context) throws VisitorException {
        System.err.println(new StringBuffer().append(context.getUrl()).append(":").append(node.getBeginLine()).append(",").append(node.getBeginColumn()).append(": Warning: || used").toString());
        this.acceptConditionalExpression(node, context);
    }

    @Override
    public void acceptFormalParameter(FormalParameter node, Context context) throws VisitorException {
        if (node.getDimension() > 0) {
            System.err.println(new StringBuffer().append(context.getUrl()).append(":").append(node.getBeginLine()).append(",").append(node.getBeginColumn()).append(": Warning: array used").toString());
        }
        this.acceptNode(node, context);
    }

    @Override
    public void acceptVariableDeclarator(VariableDeclarator node, Context context) throws VisitorException {
        if (node.getDimension() > 0) {
            System.err.println(new StringBuffer().append(context.getUrl()).append(":").append(node.getBeginLine()).append(",").append(node.getBeginColumn()).append(": Warning: array used").toString());
        }
        this.acceptNode(node, context);
    }

    @Override
    public void acceptArrayType(ArrayType node, Context context) throws VisitorException {
        System.err.println(new StringBuffer().append(context.getUrl()).append(":").append(node.getBeginLine()).append(",").append(node.getBeginColumn()).append(": Warning: array used").toString());
        this.acceptReferenceType(node, context);
    }

    @Override
    public void acceptArraySelection(ArraySelection node, Context context) throws VisitorException {
        System.err.println(new StringBuffer().append(context.getUrl()).append(":").append(node.getBeginLine()).append(",").append(node.getBeginColumn()).append(": Warning: array used").toString());
        this.acceptPrimarySuffix(node, context);
    }

    @Override
    public void acceptArrayAllocationExpression(ArrayAllocationExpression node, Context context) throws VisitorException {
        System.err.println(new StringBuffer().append(context.getUrl()).append(":").append(node.getBeginLine()).append(",").append(node.getBeginColumn()).append(": Warning: array used").toString());
        this.acceptAllocationExpression(node, context);
    }
}

