/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.util;

import de.cbockisch.jlxf.ParseException;
import de.cbockisch.jlxf.context.Context;
import de.cbockisch.jlxf.util.FileInfo;
import de.cbockisch.jlxf.util.NoTypeDefFoundException;
import de.cbockisch.jlxf.util.TypeInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfoFinder {
    public static long typeInfoMillis = 0L;
    public static long dirFindMillis = 0L;
    public static long archFindMillis = 0L;
    private Vector<ClasspathElement> classpathElements = new Vector();

    public TypeInfoFinder(Vector<String> sourcepath) {
        StringTokenizer classpathTokens = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"), false);
        while (classpathTokens.hasMoreTokens()) {
            File element = new File(classpathTokens.nextToken());
            try {
                if (element.isDirectory()) {
                    this.classpathElements.add(new ClasspathDir(element));
                    continue;
                }
                this.classpathElements.add(new ClasspathArchive(element));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Enumeration<String> sourcepathElements = sourcepath.elements();
        while (sourcepathElements.hasMoreElements()) {
            File element = new File(sourcepathElements.nextElement());
            try {
                if (element.isDirectory()) {
                    this.classpathElements.add(new ClasspathDir(element));
                    continue;
                }
                this.classpathElements.add(new ClasspathArchive(element));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public TypeInfo getTypeInfo(Context context, String typeName) throws NoTypeDefFoundException {
        long currentMillis = System.currentTimeMillis();
        TypeInfo result = this.getTypeInfoInternal(context, typeName);
        typeInfoMillis += System.currentTimeMillis() - currentMillis;
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private TypeInfo getTypeInfoInternal(Context context, String typeName) throws NoTypeDefFoundException {
        try {
            qualifiedName = context.getNamespace();
            if (!qualifiedName.equals("")) {
                qualifiedName = new StringBuffer().append(qualifiedName).append(".").toString();
            }
            qualifiedName = new StringBuffer().append(qualifiedName).append(typeName).toString();
            return this.findInClasspath(qualifiedName);
        }
        catch (NoTypeDefFoundException exception) {
            classes = context.getKnownClasses().elements();
            ** while (classes.hasMoreElements())
        }
lbl-1000:
        // 1 sources

        {
            current = classes.nextElement();
            if (!current.endsWith(typeName)) continue;
            return this.findInClasspath(current);
        }
lbl13:
        // 1 sources

        packages = context.getKnownPackages().elements();
        while (packages.hasMoreElements()) {
            current = packages.nextElement();
            if (!current.equals("")) {
                current = new StringBuffer().append(current).append(".").toString();
            }
            current = new StringBuffer().append(current).append(typeName).toString();
            try {
                typeInfo = this.findInClasspath(current);
                return typeInfo;
            }
            catch (NoTypeDefFoundException exception) {
                // empty catch block
            }
        }
        throw new NoTypeDefFoundException(context, typeName);
    }

    private TypeInfo findInClasspath(String qualifiedTypeName) throws NoTypeDefFoundException {
        Enumeration<ClasspathElement> classpathElement = this.classpathElements.elements();
        while (classpathElement.hasMoreElements()) {
            try {
                return this.find(classpathElement.nextElement(), qualifiedTypeName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new NoTypeDefFoundException(qualifiedTypeName);
    }

    private TypeInfo find(ClasspathElement element, String className) throws NoTypeDefFoundException, IOException, ParseException {
        StringTokenizer tokens = new StringTokenizer(className, ".", false);
        String outerClass = new String();
        while (tokens.hasMoreTokens()) {
            TypeInfo typeInfo;
            outerClass = new StringBuffer().append(outerClass).append(tokens.nextToken()).toString();
            try {
                typeInfo = new TypeInfo(className, element.find(new StringBuffer().append(outerClass).append(".java").toString()));
                if (!tokens.hasMoreTokens()) {
                    return typeInfo;
                }
            }
            catch (NoTypeDefFoundException exception) {
                // empty catch block
            }
            try {
                typeInfo = new TypeInfo(className, element.find(new StringBuffer().append(outerClass).append(".task").toString()));
                if (!tokens.hasMoreTokens()) {
                    return typeInfo;
                }
            }
            catch (NoTypeDefFoundException exception) {
                // empty catch block
            }
            outerClass = new StringBuffer().append(outerClass).append(System.getProperty("file.separator")).toString();
        }
        String classFilename = className.replace('.', '$');
        classFilename = new StringBuffer().append(classFilename).append(".class").toString();
        while (true) {
            int firstDollarPos;
            if ((firstDollarPos = classFilename.indexOf(36)) == -1) {
                firstDollarPos = classFilename.length();
            }
            try {
                return new TypeInfo(className, element.find(classFilename));
            }
            catch (NoTypeDefFoundException exception) {
                if (firstDollarPos == classFilename.length()) continue;
                classFilename = new StringBuffer().append(classFilename.substring(0, firstDollarPos)).append(System.getProperty("file.separator")).append(classFilename.substring(firstDollarPos + 1)).toString();
                if (firstDollarPos < classFilename.length()) continue;
                throw new NoTypeDefFoundException(className);
            }
            break;
        }
    }

    protected static class ClasspathArchive
    implements ClasspathElement {
        ZipFile archive;
        URL archiveName;

        public ClasspathArchive(File archive) throws Exception {
            try {
                this.archive = new ZipFile(archive);
                this.archiveName = archive.toURL();
            }
            catch (Exception exception) {
                throw new Exception("no valid archive file: " + archive);
            }
        }

        public FileInfo find(String entry) throws NoTypeDefFoundException, IOException, ParseException {
            long currentMillis = System.currentTimeMillis();
            entry = entry.replace(System.getProperty("file.separator").charAt(0), '/');
            ZipEntry zipEntry = this.archive.getEntry(entry);
            archFindMillis += System.currentTimeMillis() - currentMillis;
            if (zipEntry != null) {
                FileInfo result = FileInfo.getFileInfo(new URL(this.archiveName + "#" + zipEntry.getName()));
                return result;
            }
            throw new NoTypeDefFoundException(entry);
        }
    }

    protected static class ClasspathDir
    implements ClasspathElement {
        private File base;

        public ClasspathDir(File base) {
            this.base = base;
        }

        public FileInfo find(String entry) throws NoTypeDefFoundException, IOException, ParseException {
            long currentMillis = System.currentTimeMillis();
            File file = new File(this.base + System.getProperty("file.separator") + entry);
            dirFindMillis += System.currentTimeMillis() - currentMillis;
            if (file.exists()) {
                FileInfo result = FileInfo.getFileInfo(file.toURL());
                return result;
            }
            throw new NoTypeDefFoundException(entry);
        }
    }

    protected static interface ClasspathElement {
        public FileInfo find(String var1) throws NoTypeDefFoundException, IOException, ParseException;
    }
}

