/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.util;

import de.cbockisch.jlxf.context.CompilationUnitContext;
import de.cbockisch.jlxf.context.Context;
import de.cbockisch.jlxf.context.IllegalNodeTypeException;
import de.cbockisch.jlxf.context.TypeDeclarationContext;
import de.cbockisch.jlxf.nodes.ClassDeclaration;
import de.cbockisch.jlxf.nodes.ClassOrInterfaceType;
import de.cbockisch.jlxf.nodes.InterfaceDeclaration;
import de.cbockisch.jlxf.nodes.Node;
import de.cbockisch.jlxf.nodes.ReferenceType;
import de.cbockisch.jlxf.nodes.UnqualifiedTypeIdentifier;
import de.cbockisch.jlxf.util.FileInfo;
import de.cbockisch.jlxf.util.NoTypeDefFoundException;
import de.cbockisch.jlxf.util.TypeInfo;
import de.cbockisch.jlxf.util.TypeInfoFinder;
import de.cbockisch.jlxf.visitors.Visitor;
import de.cbockisch.jlxf.visitors.VisitorException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDependenciesVisitor
extends Visitor {
    public static long typeVisitMillis = 0L;
    private static Hashtable<String, TypeInfo> typeDependencies = new Hashtable();
    private TypeInfoFinder typeInfoFinder;
    private String packageName;

    public TypeDependenciesVisitor(Vector<String> sourcepath) {
        this.typeInfoFinder = new TypeInfoFinder(sourcepath);
    }

    private void addTypeDependency(TypeInfo ti) {
        if (!typeDependencies.containsKey(ti.getQualifiedName()) || typeDependencies.containsKey(ti.getQualifiedName()) && typeDependencies.get(ti.getQualifiedName()).getDefinition() == null) {
            typeDependencies.put(ti.getQualifiedName(), ti);
        }
    }

    @Override
    public void acceptNode(Node node, Context context) throws VisitorException {
        Enumeration<Node> enumeration = node.getChildren();
        while (enumeration.hasMoreElements()) {
            Node current = enumeration.nextElement();
            if (current == null) continue;
            current.visit(this, context);
        }
    }

    @Override
    public void start(Node node, URL url) throws IllegalNodeTypeException, VisitorException {
        long currentMillis = System.currentTimeMillis();
        CompilationUnitContext cuContext = new CompilationUnitContext(url);
        cuContext.setDefinition(node);
        node.visit(this, cuContext);
        typeVisitMillis += System.currentTimeMillis() - currentMillis;
    }

    public Enumeration<TypeInfo> getTypeDependencies() {
        return typeDependencies.elements();
    }

    @Override
    public void acceptClassDeclaration(ClassDeclaration node, Context context) throws VisitorException {
        TypeInfo ti;
        Context newContext = new TypeDeclarationContext();
        try {
            newContext.setDefinition(node);
            newContext.setParentContext(context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            newContext = context;
        }
        try {
            ti = new TypeInfo(newContext.getName(), FileInfo.getFileInfo(newContext.getUrl()), node);
        }
        catch (Exception exception) {
            VisitorException visitorException = new VisitorException();
            visitorException.initCause(exception);
            throw visitorException;
        }
        this.addTypeDependency(ti);
        this.acceptTypeDeclaration(node, newContext);
    }

    @Override
    public void acceptInterfaceDeclaration(InterfaceDeclaration node, Context context) throws VisitorException {
        TypeInfo ti;
        Context newContext = new TypeDeclarationContext();
        try {
            newContext.setDefinition(node);
            newContext.setParentContext(context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            newContext = context;
        }
        try {
            ti = new TypeInfo(newContext.getName(), FileInfo.getFileInfo(newContext.getUrl()), node);
        }
        catch (Exception exception) {
            VisitorException visitorException = new VisitorException();
            visitorException.initCause(exception);
            throw visitorException;
        }
        this.addTypeDependency(ti);
        this.acceptTypeDeclaration(node, newContext);
    }

    @Override
    public void acceptClassOrInterfaceType(ClassOrInterfaceType node, Context context) throws VisitorException {
        String typeName = new String();
        Enumeration<UnqualifiedTypeIdentifier> enumeration = node.getUnqualifiedTypeIdentifiers().elements();
        while (enumeration.hasMoreElements()) {
            UnqualifiedTypeIdentifier current = enumeration.nextElement();
            typeName = new StringBuffer().append(typeName).append(current.getIdentifier()).toString();
            if (enumeration.hasMoreElements()) {
                typeName = new StringBuffer().append(typeName).append(".").toString();
            }
            Enumeration<ReferenceType> typeArguments = current.getTypeArguments().elements();
            while (typeArguments.hasMoreElements()) {
                typeArguments.nextElement().visit(this, context);
            }
        }
        Object ti = null;
        try {
            this.addTypeDependency(this.typeInfoFinder.getTypeInfo(context, typeName));
        }
        catch (NoTypeDefFoundException exception) {}
    }

    public Hashtable<String, TypeInfo> getTypeInfos() {
        return typeDependencies;
    }
}

