/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.util;

import de.cbockisch.jlxf.ParseException;
import de.cbockisch.jlxf.context.IllegalNodeTypeException;
import de.cbockisch.jlxf.execution.Commandline;
import de.cbockisch.jlxf.execution.IllegalUseError;
import de.cbockisch.jlxf.execution.Option;
import de.cbockisch.jlxf.util.FileInfo;
import de.cbockisch.jlxf.util.TypeDependenciesVisitor;
import de.cbockisch.jlxf.util.TypeInfo;
import de.cbockisch.jlxf.visitors.VisitorException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDependencies {
    private Vector<FileInfo> fileInfos;
    private TypeDependenciesVisitor typeDep;

    public static Enumeration<Option> getOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("sourcepath", "Specify where to find input source files", "path"));
        return result.elements();
    }

    public Vector<FileInfo> getFileInfos() {
        return (Vector)this.fileInfos.clone();
    }

    public void resolveDependencies(Commandline commandline) throws IOException, ParseException, VisitorException, IllegalUseError {
        this.typeDep = new TypeDependenciesVisitor(commandline.getOption("sourcepath").getArguments(System.getProperty("path.separator")));
        FileInfo.clearCache();
        this.fileInfos = new Vector();
        Vector<FileInfo> unprocessed = new Vector<FileInfo>();
        Enumeration<URL> sourceFiles = commandline.getSourceFiles().elements();
        while (sourceFiles.hasMoreElements()) {
            unprocessed.add(FileInfo.getFileInfo(sourceFiles.nextElement()));
        }
        while (unprocessed.size() > 0) {
            FileInfo current = (FileInfo)unprocessed.firstElement();
            this.fileInfos.add(current);
            unprocessed.remove(current);
            if (!current.isSource()) continue;
            try {
                Enumeration<FileInfo> res = this.process(current).elements();
                while (res.hasMoreElements()) {
                    FileInfo currentRes = res.nextElement();
                    if (this.fileInfos.contains(currentRes) || unprocessed.contains(currentRes)) continue;
                    unprocessed.add(currentRes);
                }
            }
            catch (IllegalNodeTypeException exception) {
                exception.printStackTrace();
            }
        }
    }

    private Vector<FileInfo> process(FileInfo fi) throws IllegalNodeTypeException, IOException, ParseException, VisitorException {
        Vector<FileInfo> result = new Vector<FileInfo>();
        if (!fi.isSource()) {
            return result;
        }
        this.typeDep.start(fi.getCompilationUnit(), fi.getUrl());
        Enumeration<TypeInfo> types = this.typeDep.getTypeDependencies();
        while (types.hasMoreElements()) {
            FileInfo current = types.nextElement().getFileInfo();
            if (this.fileInfos.contains(current) || result.contains(current)) continue;
            result.add(current);
        }
        return result;
    }

    public Hashtable<String, TypeInfo> getTypeInfos() {
        return this.typeDep.getTypeInfos();
    }
}

