/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.util;

import de.cbockisch.jlxf.execution.Commandline;
import de.cbockisch.jlxf.nodes.Node;
import de.cbockisch.jlxf.util.CompilerAdapter;
import de.cbockisch.jlxf.util.FileInfo;
import de.cbockisch.jlxf.visitors.FindByGenPosVisitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Javac
extends CompilerAdapter {
    Hashtable<String, FileInfo> files;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean compile(Commandline commandline, Hashtable<String, FileInfo> files) {
        boolean bl;
        this.files = files;
        PrintWriter out = null;
        try {
            try {
                String command;
                File tmpFile = File.createTempFile("jlxf", null);
                tmpFile.deleteOnExit();
                out = new PrintWriter(new FileWriter(tmpFile));
                Enumeration<String> filesEnum = files.keys();
                while (true) {
                    if (!filesEnum.hasMoreElements()) {
                        out.flush();
                        command = new StringBuffer().append("javac -classpath ").append(System.getProperty("java.class.path")).append(" ").toString();
                        if (!commandline.getOption("d").isPresent()) break;
                        command = new StringBuffer().append(command).append("-d ").append(commandline.getOption("d").getArgument()).append(" ").toString();
                    }
                    out.println(filesEnum.nextElement());
                }
                bl = !this.execute(command = new StringBuffer().append(command).append(" @").append(tmpFile.getAbsolutePath()).toString());
                Object var9_9 = null;
                if (out == null) return bl;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating temporary file");
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Throwable t) {
                throw throwable;
            }
        }
        try {}
        catch (Throwable t) {
            // empty catch block
            return bl;
        }
        out.close();
        return bl;
    }

    protected boolean execute(String command) {
        boolean errors = false;
        try {
            Process proc = Runtime.getRuntime().exec(command);
            StreamPumper inputPumper = new StreamPumper(proc.getInputStream());
            StreamPumper errorPumper = new StreamPumper(proc.getErrorStream());
            inputPumper.start();
            errorPumper.start();
            proc.waitFor();
            errors = inputPumper.getErrorsOccurred() || errorPumper.getErrorsOccurred();
            inputPumper.join();
            errorPumper.join();
            proc.destroy();
        }
        catch (IOException ioe) {
            throw new RuntimeException(new StringBuffer().append("Error exec: ").append(command).toString());
        }
        catch (InterruptedException ex) {
        }
        return errors;
    }

    class StreamPumper
    extends Thread {
        private BufferedReader din;
        private boolean endOfStream = false;
        private int SLEEP_TIME = 5;
        private int BUFFER_SIZE = 1024;
        private boolean errorsOccurred = false;
        private String errorDescription;
        private String errorSymbol;
        private String errorLocation;
        private String errorSource;
        private String errorMarker;
        private FindByGenPosVisitor findByGenPos = new FindByGenPosVisitor();

        public boolean getErrorsOccurred() {
            return this.errorsOccurred;
        }

        private void handleLine(String line) {
            this.errorsOccurred = true;
            if (this.errorDescription == null) {
                this.errorDescription = line;
            } else if (this.errorSymbol == null && this.errorLocation == null && this.errorMarker == null && line.startsWith("symbol")) {
                this.errorSymbol = line;
            } else if (this.errorLocation == null && this.errorSource == null && line.startsWith("location")) {
                this.errorLocation = line;
            } else if (this.errorSource == null) {
                this.errorSource = line;
            } else {
                this.errorMarker = line;
                this.outputError();
                this.errorDescription = null;
                this.errorSymbol = null;
                this.errorLocation = null;
                this.errorSource = null;
                this.errorMarker = null;
            }
        }

        private void outputError() {
            StringTokenizer tokens = new StringTokenizer(this.errorDescription, ":", false);
            File file = null;
            int colonPos = this.errorDescription.indexOf(".java:") + ".java".length();
            try {
                file = new File(this.errorDescription.substring(0, colonPos)).getCanonicalFile();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            int line = Integer.parseInt(this.errorDescription.substring(colonPos + 1, this.errorDescription.indexOf(":", colonPos + 1)));
            colonPos = this.errorDescription.indexOf(":", colonPos + 1);
            int pos = this.errorMarker.indexOf("^");
            String description = this.errorDescription.substring(colonPos + 1);
            String symbol = null;
            String location = null;
            String source = null;
            String marker = null;
            if (this.errorSymbol != null) {
                symbol = this.errorSymbol.substring("symbol  : ".length());
            }
            if (this.errorLocation != null) {
                location = this.errorLocation.substring("location: ".length());
            }
            source = this.errorSource;
            marker = this.errorMarker;
            FileInfo current = Javac.this.files.get(file.toString());
            this.outputError(file, current, line, pos, description, symbol, location, source, marker);
        }

        private void outputError(File file, FileInfo fi, int line, int pos, String desc, String symb, String loc, String src, String marker) {
            this.findByGenPos.setPosition(line, pos);
            try {
                this.findByGenPos.start(fi.getCompilationUnit(), null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Node node = this.findByGenPos.getNode();
            if (node == null) {
                System.err.println("error in generated code");
                System.err.println(file + ":" + line + "," + pos + ":" + desc);
            } else {
                System.err.println(fi + ":" + node.getBeginLine() + "," + node.getBeginColumn() + ":" + desc);
            }
            if (symb != null) {
                System.err.println("symbol  : " + symb);
            }
            if (loc != null) {
                if (loc.equals("class KarelTask")) {
                    loc = "task";
                }
                System.err.println("location: " + loc);
            }
            System.err.println(src);
            System.err.println(marker);
        }

        public StreamPumper(InputStream is) {
            this.din = new BufferedReader(new InputStreamReader(is));
        }

        public void pumpStream() throws IOException {
            byte[] buf = new byte[this.BUFFER_SIZE];
            if (!this.endOfStream) {
                String line = this.din.readLine();
                if (line != null) {
                    this.handleLine(line);
                } else {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                try {
                    while (!this.endOfStream) {
                        this.pumpStream();
                        Thread.sleep(this.SLEEP_TIME);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.din.close();
            }
            catch (IOException ioe) {}
        }
    }
}

