/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.util;

import de.cbockisch.jlxf.nodes.Node;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class Iterator {
    protected NodeListElement current = new NodeListElement(){

        public Node getValue() {
            throw new NoSuchElementException();
        }

        public void remove() {
        }

        public void replace(Node newElement) {
        }
    };

    public Iterator() {
        this.init();
    }

    protected abstract void init();

    public Node getNext() {
        this.advance();
        return this.getCurrent();
    }

    private Node getCurrent() {
        if (this.current == null || this.current.getValue() == null) {
            throw new NoSuchElementException();
        }
        return this.current.getValue();
    }

    public boolean hasNext() {
        if (this.current == null) {
            return false;
        }
        return this.current.hasNext();
    }

    private void advance() {
        if (this.current == null) {
            return;
        }
        this.current = this.current.next();
    }

    public void remove() {
        if (this.current == null || this.current.getValue() == null) {
            throw new NoSuchElementException();
        }
        this.current.remove();
    }

    public void replace(Node newElement) {
        if (this.current == null || this.current.getValue() == null) {
            throw new NoSuchElementException();
        }
        this.current.replace(newElement);
    }

    protected static class VectorNodeListElement
    extends NodeListElement {
        private NodeListElement next;
        private int cursor = 0;
        private Vector vector;
        private boolean removed = false;

        public VectorNodeListElement(Vector vector) {
            this.vector = vector;
        }

        public void setNextElement(NodeListElement next) {
            this.next = next;
        }

        public NodeListElement next() {
            if (!this.removed) {
                ++this.cursor;
            }
            this.removed = false;
            while (this.cursor < this.vector.size()) {
                if (this.vector.elementAt(this.cursor) == null) continue;
                return this;
            }
            if (this.next != null && this.next.getValue() == null) {
                return this.next.next();
            }
            return this.next;
        }

        public boolean hasNext() {
            int lookaheadCursor = this.cursor;
            if (!this.removed) {
                ++lookaheadCursor;
            }
            while (lookaheadCursor < this.vector.size()) {
                if (this.vector.elementAt(this.cursor) == null) continue;
                return true;
            }
            if (this.next == null) {
                return false;
            }
            if (this.next.getValue() != null) {
                return true;
            }
            return this.next.hasNext();
        }

        public Node getValue() {
            if (this.cursor >= this.vector.size()) {
                return null;
            }
            return (Node)this.vector.elementAt(this.cursor);
        }

        public void remove() {
            this.vector.removeElementAt(this.cursor);
            this.removed = true;
        }

        public void replace(Node newElement) {
            this.vector.setElementAt(newElement, this.cursor);
        }
    }

    protected static abstract class NodeListElement {
        private NodeListElement next;

        protected NodeListElement() {
        }

        public void setNextElement(NodeListElement next) {
            this.next = next;
        }

        public NodeListElement next() {
            NodeListElement result = this.next;
            if (this.next != null && this.next.getValue() == null) {
                return this.next.next();
            }
            return this.next;
        }

        public boolean hasNext() {
            if (this.next == null) {
                return false;
            }
            if (this.next.getValue() != null) {
                return true;
            }
            return this.next.hasNext();
        }

        public abstract Node getValue();

        public abstract void remove();

        public abstract void replace(Node var1);
    }
}

