/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.util;

import de.cbockisch.jlxf.GJavaParser;
import de.cbockisch.jlxf.ParseException;
import de.cbockisch.jlxf.nodes.CompilationUnit;
import de.cbockisch.jlxf.util.TypeInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfo {
    public static long parseMillis = 0L;
    private URL url;
    private URL base;
    private Vector<TypeInfo> types = new Vector();
    private String packageName;
    private CompilationUnit compilationUnit;
    private static Hashtable<String, FileInfo> fileInfos = new Hashtable();

    public static FileInfo getFileInfo(URL url) throws IOException, ParseException {
        long currentMillis = System.currentTimeMillis();
        FileInfo result = fileInfos.get(url.toString());
        if (result == null) {
            result = new FileInfo(url);
            if (result.isSource()) {
                try {
                    result.compilationUnit = GJavaParser.parse(result.getAsStream());
                }
                catch (ParseException exception) {
                    System.err.println(new StringBuffer().append("Syntax error in file: ").append(url).toString());
                    System.err.println(exception.getMessage());
                    throw exception;
                }
            }
            fileInfos.put(url.toString(), result);
        }
        parseMillis += System.currentTimeMillis() - currentMillis;
        return result;
    }

    public static void clearCache() {
        fileInfos.clear();
    }

    public static Enumeration<FileInfo> getFileInfos() {
        return fileInfos.elements();
    }

    private FileInfo(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getBase() throws Exception {
        if (this.base == null) {
            throw new Exception("Illegal State");
        }
        return this.base;
    }

    public Enumeration<TypeInfo> getTypes() {
        return this.types.elements();
    }

    public InputStream getAsStream() throws IOException {
        try {
            return this.url.openStream();
        }
        catch (IOException exception) {
            IOException resultException = new IOException(new StringBuffer().append("Could not open file: ").append(this.url).toString());
            resultException.initCause(exception);
            throw resultException;
        }
    }

    public void addType(TypeInfo type) {
        this.types.add(type);
    }

    public String getPackage() {
        if (this.packageName == null) {
            return "";
        }
        return this.packageName;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public boolean isSource() {
        return !this.getUrl().toString().endsWith(".class");
    }

    public String toString() {
        return this.getUrl().toString();
    }
}

