/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.util;

import de.cbockisch.jlxf.execution.Commandline;
import de.cbockisch.jlxf.execution.IllegalUseError;
import de.cbockisch.jlxf.execution.Option;
import de.cbockisch.jlxf.nodes.ClassDeclaration;
import de.cbockisch.jlxf.nodes.CompilationUnit;
import de.cbockisch.jlxf.nodes.InterfaceDeclaration;
import de.cbockisch.jlxf.nodes.TypeDeclaration;
import de.cbockisch.jlxf.util.FileInfo;
import de.cbockisch.jlxf.visitors.PrettyPrintVisitor;
import de.cbockisch.jlxf.visitors.VisitorException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstWriter {
    public static Enumeration<Option> getOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("instdir", "The directory to temporarily output instrumented files", "path", "inst"));
        return result.elements();
    }

    public Hashtable<String, FileInfo> output(Commandline commandline, Vector<FileInfo> fileInfos) throws IllegalUseError, IOException, VisitorException {
        Hashtable<String, FileInfo> filenames = new Hashtable<String, FileInfo>();
        File instDir = commandline.getOption("instdir").isPresent() ? new File(commandline.getOption("instdir").getArgument()) : new File("inst");
        if (!instDir.exists()) {
            instDir.mkdir();
        }
        if (!instDir.isDirectory()) {
            throw new IllegalUseError(new StringBuffer().append("output directory for instrumented files: ").append(instDir).append(" is no valid directoy").toString());
        }
        String baseDir = new StringBuffer().append(instDir).append(System.getProperty("file.separator")).toString();
        Enumeration<FileInfo> enumeration = fileInfos.elements();
        while (enumeration.hasMoreElements()) {
            FileInfo current = enumeration.nextElement();
            if (!current.isSource()) continue;
            CompilationUnit cu = current.getCompilationUnit();
            String packageDir = cu.getPackageName();
            if (packageDir == null) {
                packageDir = "";
            }
            packageDir = new StringBuffer().append(packageDir.replace('.', System.getProperty("file.separator").charAt(0))).append(System.getProperty("file.separator")).toString();
            File dir = new File(new StringBuffer().append(baseDir).append(packageDir).toString());
            if (!dir.mkdirs() && !dir.exists()) {
                throw new IllegalUseError(new StringBuffer().append("Could not create directory: ").append(baseDir).append(packageDir).toString());
            }
            String origFilename = current.getUrl().toString().replace('/', System.getProperty("file.separator").charAt(0));
            String filename = null;
            if (origFilename.lastIndexOf(packageDir) < 0) {
                throw new IllegalUseError(new StringBuffer().append("File ").append(current.getUrl()).append(" is member of package ").append(cu.getPackageName()).append(" and must be within the subdirectory ").append(packageDir).toString());
            }
            filename = origFilename.substring(origFilename.lastIndexOf(packageDir) + packageDir.length());
            File file = new File(new StringBuffer().append(baseDir).append(packageDir).append(this.getClassFilename(filename, cu)).toString());
            filenames.put(file.getCanonicalFile().toString(), current);
            try {
                if (!file.createNewFile() && !file.exists()) {
                    throw new IOException(new StringBuffer().append("Could not open file ").append(baseDir).append(packageDir).append(filename).append(" for writing").toString());
                }
            }
            catch (IOException exception) {
                IOException ioException = new IOException(new StringBuffer().append("Could not open file ").append(baseDir).append(packageDir).append(filename).append(" for writing").toString());
                ioException.initCause(exception);
                throw ioException;
            }
            PrettyPrintVisitor ppv = new PrettyPrintVisitor(new PrintWriter((Writer)new FileWriter(file), true), 4);
            ppv.start(current.getCompilationUnit(), null);
        }
        return filenames;
    }

    private String getClassFilename(String filename, CompilationUnit cu) {
        Enumeration<TypeDeclaration> types = cu.getTypeDeclarations().elements();
        String publicTypeName = null;
        while (types.hasMoreElements()) {
            InterfaceDeclaration currentInterface;
            TypeDeclaration current = types.nextElement();
            if (current instanceof ClassDeclaration) {
                ClassDeclaration currentClass = (ClassDeclaration)current;
                if (!Modifier.isPublic(currentClass.getModifiers())) continue;
                if (publicTypeName != null) {
                    System.out.println(new StringBuffer().append("warning: file: ").append(filename).append(" contains more than one public type").toString());
                    continue;
                }
                publicTypeName = currentClass.getName();
                continue;
            }
            if (!(current instanceof InterfaceDeclaration) || !Modifier.isPublic((currentInterface = (InterfaceDeclaration)current).getModifiers())) continue;
            if (publicTypeName != null) {
                System.out.println(new StringBuffer().append("warning: file: ").append(filename).append(" contains more than one public type").toString());
                continue;
            }
            publicTypeName = currentInterface.getName();
        }
        if (filename.endsWith(".task")) {
            if (publicTypeName == null) {
                return new StringBuffer().append(filename.substring(0, filename.length() - ".task".length())).append(".java").toString();
            }
            return new StringBuffer().append(publicTypeName).append(".java").toString();
        }
        if (publicTypeName == null) {
            return filename;
        }
        return new StringBuffer().append(publicTypeName).append(".java").toString();
    }
}

