/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.nodes;

import de.cbockisch.jlxf.context.Context;
import de.cbockisch.jlxf.nodes.NodeSourceInfo;
import de.cbockisch.jlxf.util.Iterator;
import de.cbockisch.jlxf.visitors.Visitor;
import de.cbockisch.jlxf.visitors.VisitorException;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    private String leadingSkipped;
    private String tailingSkipped;
    private int beginLine;
    private int beginColumn;
    private int endLine;
    private int endColumn;
    private Hashtable<String, Object> data = new Hashtable();
    private Context outerContext;

    public void setBeginInfo(NodeSourceInfo info) {
        this.leadingSkipped = info.skipped;
        this.beginLine = info.line;
        this.beginColumn = info.column;
    }

    public void setEndInfo(NodeSourceInfo info) {
        this.tailingSkipped = info.skipped;
        this.endLine = info.line;
        this.endColumn = info.column;
    }

    public String getLeadingSkipped() {
        return this.leadingSkipped;
    }

    public String getTailingSkipped() {
        return this.tailingSkipped;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void visit(Visitor visitor, Context context) throws VisitorException {
        visitor.acceptNode(this, context);
    }

    public void setData(String name, Object data) {
        this.data.put(name, data);
    }

    public Object getData(String name) {
        return this.data.get(name);
    }

    public abstract Enumeration<Node> getChildren();

    public abstract Iterator getIterator();

    public void setOuterContext(Context outerContext) {
        this.outerContext = outerContext;
    }

    public Context getOuterContext() {
        return this.outerContext;
    }
}

