/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.execution;

import de.cbockisch.jlxf.ParseException;
import de.cbockisch.jlxf.context.Context;
import de.cbockisch.jlxf.context.IllegalContextException;
import de.cbockisch.jlxf.context.IllegalNodeTypeException;
import de.cbockisch.jlxf.execution.Commandline;
import de.cbockisch.jlxf.execution.IllegalUseError;
import de.cbockisch.jlxf.execution.Option;
import de.cbockisch.jlxf.util.AstWriter;
import de.cbockisch.jlxf.util.CompilerAdapter;
import de.cbockisch.jlxf.util.FileInfo;
import de.cbockisch.jlxf.util.TypeDependencies;
import de.cbockisch.jlxf.visitors.Visitor;
import de.cbockisch.jlxf.visitors.VisitorException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocessor {
    private Vector<Visitor> visitors;
    private String invocationCommand;
    private String header;
    private CompilerAdapter compiler;
    private Commandline commandline;

    public void process(String[] arguments, Vector<Visitor> visitors, Vector<Option> options, String invocationCommand, String header, CompilerAdapter compiler) {
        this.setParameters(arguments, visitors, options, invocationCommand, header, compiler);
        this.process();
    }

    public boolean process() {
        try {
            TypeDependencies td = new TypeDependencies();
            td.resolveDependencies(this.commandline);
            Context.setTypeInfos(td.getTypeInfos());
            Vector<FileInfo> fileInfos = td.getFileInfos();
            Enumeration<Visitor> visitorEnum = this.visitors.elements();
            while (visitorEnum.hasMoreElements()) {
                Visitor currentVisitor = visitorEnum.nextElement();
                Enumeration<FileInfo> fileInfoEnum = fileInfos.elements();
                while (fileInfoEnum.hasMoreElements()) {
                    FileInfo currentFI = fileInfoEnum.nextElement();
                    if (!currentFI.isSource()) continue;
                    currentVisitor.start(currentFI.getCompilationUnit(), currentFI.getUrl());
                }
            }
            AstWriter aw = new AstWriter();
            Hashtable<String, FileInfo> filenames = aw.output(this.commandline, fileInfos);
            return this.compiler.compile(this.commandline, filenames);
        }
        catch (IllegalUseError error) {
            this.commandline.printUsage(new PrintWriter(System.out, true), error);
            System.exit(1);
        }
        catch (ParseException exception) {
        }
        catch (IOException exception) {
            System.out.println("I/O exception occurred while preprocessing:");
            exception.printStackTrace();
        }
        catch (VisitorException exception) {
            exception.printStackTrace();
        }
        catch (IllegalNodeTypeException exception) {
            exception.printStackTrace();
        }
        catch (IllegalContextException exception) {
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public Commandline setParameters(String[] arguments, Vector<Visitor> visitors, Vector<Option> options, String invocationCommand, String header, CompilerAdapter compiler) {
        this.commandline = new Commandline(invocationCommand, header);
        Enumeration<Visitor> visitorEnum = visitors.elements();
        while (visitorEnum.hasMoreElements()) {
            this.commandline.addOptions(visitorEnum.nextElement().getOptions());
        }
        this.commandline.addOptions(TypeDependencies.getOptions());
        this.commandline.addOptions(AstWriter.getOptions());
        this.commandline.addOptions(compiler.getOptions());
        this.commandline.addOptions(options.elements());
        this.commandline.parseCommandline(arguments);
        this.visitors = visitors;
        this.invocationCommand = invocationCommand;
        this.header = header;
        this.compiler = compiler;
        return this.commandline;
    }
}

