/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.execution;

import de.cbockisch.jlxf.execution.IllegalUseError;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Option {
    private String switchImage;
    private String meaning;
    private String argumentName;
    private boolean present;
    private String argument;
    private String defaultArgument;

    public Option(String switchImage, String meaning, String argumentName) {
        this.switchImage = switchImage;
        this.meaning = meaning;
        this.argumentName = argumentName;
        this.reset();
    }

    public Option(String switchImage, String meaning, String argumentName, String defaultArgument) {
        this.switchImage = switchImage;
        this.meaning = meaning;
        this.argumentName = argumentName;
        this.defaultArgument = defaultArgument;
        this.reset();
    }

    public void reset() {
        this.present = false;
        this.argument = null;
    }

    public int parse(String[] args, int pos) throws IllegalUseError {
        if (pos >= args.length || !args[pos].equals(new StringBuffer().append("-").append(this.getSwitch()).toString())) {
            throw new IllegalUseError(this);
        }
        ++pos;
        if (this.argumentName != null) {
            if (pos >= args.length || args[pos].startsWith("-")) {
                throw new IllegalUseError(this);
            }
            this.argument = args[pos];
            ++pos;
        }
        this.present = true;
        return pos;
    }

    public String getSwitch() {
        return this.switchImage;
    }

    public String getUsage() {
        String result = new String();
        result = new StringBuffer().append("-").append(this.switchImage).toString();
        if (this.argumentName != null) {
            result = new StringBuffer().append(result).append(" <").append(this.argumentName).append(">").toString();
        }
        result = new StringBuffer().append(result).append(" ").toString();
        while (result.length() < 20) {
            result = new StringBuffer().append(result).append(" ").toString();
        }
        result = new StringBuffer().append(result).append(this.meaning).toString();
        return result;
    }

    public boolean isPresent() {
        return this.present || this.defaultArgument != null;
    }

    public String getArgument() {
        if (this.argument != null) {
            return this.argument;
        }
        return this.defaultArgument;
    }

    public Vector<String> getArguments(String delimeters) {
        Vector<String> result = new Vector<String>();
        StringTokenizer tokens = null;
        if (this.argument != null) {
            tokens = new StringTokenizer(this.argument, delimeters, false);
        } else if (this.defaultArgument != null) {
            tokens = new StringTokenizer(this.defaultArgument, delimeters, false);
        }
        if (tokens != null) {
            while (tokens.hasMoreTokens()) {
                result.add(tokens.nextToken());
            }
        }
        return result;
    }

    public String toString() {
        return new StringBuffer().append(this.getUsage()).append(" (present: ").append(this.present).append(", argument: ").append(this.argument).append(", defaultArgument: ").append(this.defaultArgument).append(")").toString();
    }
}

