/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.context;

import de.cbockisch.jlxf.context.IllegalContextException;
import de.cbockisch.jlxf.context.IllegalNodeTypeException;
import de.cbockisch.jlxf.execution.Commandline;
import de.cbockisch.jlxf.nodes.Node;
import de.cbockisch.jlxf.util.TypeInfo;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Context {
    public static Hashtable<String, TypeInfo> typeInfos;
    private static Commandline commandline;

    public abstract void setDefinition(Node var1) throws IllegalNodeTypeException;

    public abstract void setParentContext(Context var1) throws IllegalContextException;

    public abstract Context getParentContext();

    public abstract String getNamespace();

    public abstract String getName();

    public abstract Node getDefinition();

    public abstract Vector<String> getKnownClasses();

    public abstract Vector<String> getKnownPackages();

    public abstract int getModifiers();

    public abstract URL getUrl();

    public abstract String toString();

    public static void setCommandline(Commandline commandline) {
        Context.commandline = commandline;
    }

    public Commandline getCommandline() {
        return commandline;
    }

    public static void setTypeInfos(Hashtable<String, TypeInfo> typeInfos) {
        Context.typeInfos = typeInfos;
    }

    public static TypeInfo getTypeInfo(String qualifiedName) {
        return typeInfos.get(qualifiedName);
    }

    public static TypeInfo getTypeInfo(String name, Context context) {
        String current;
        Vector<String> possibleNames = new Vector<String>();
        possibleNames.add(name);
        if (context.getNamespace() != null && !context.getNamespace().equals("")) {
            possibleNames.add(new StringBuffer().append(context.getNamespace()).append(".").append(name).toString());
        }
        Enumeration<String> enumeration = context.getKnownClasses().elements();
        while (enumeration.hasMoreElements()) {
            current = enumeration.nextElement();
            if (!current.endsWith(name)) continue;
            possibleNames.add(current);
        }
        enumeration = context.getKnownPackages().elements();
        while (enumeration.hasMoreElements()) {
            possibleNames.add(new StringBuffer().append(enumeration.nextElement()).append(".").append(name).toString());
        }
        enumeration = possibleNames.elements();
        while (enumeration.hasMoreElements()) {
            current = enumeration.nextElement();
            TypeInfo result = null;
            if (current != null) {
                result = typeInfos.get(current);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

