/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf.context;

import de.cbockisch.jlxf.context.Context;
import de.cbockisch.jlxf.context.IllegalContextException;
import de.cbockisch.jlxf.context.IllegalNodeTypeException;
import de.cbockisch.jlxf.context.NoDefinitionSetException;
import de.cbockisch.jlxf.context.NoParentContextSetException;
import de.cbockisch.jlxf.nodes.CompilationUnit;
import de.cbockisch.jlxf.nodes.Node;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnitContext
extends Context {
    private URL url;
    private Context parentContext;
    private CompilationUnit definition;
    static /* synthetic */ Class class$de$cbockisch$jlxf$nodes$CompilationUnit;

    public CompilationUnitContext(String filename) throws MalformedURLException {
        this(new File(filename).toURL());
    }

    public CompilationUnitContext(URL url) {
        this.url = url;
    }

    @Override
    public void setDefinition(Node definition) throws IllegalNodeTypeException {
        if (definition != null && !(definition instanceof CompilationUnit)) {
            throw new IllegalNodeTypeException(definition.getClass(), class$de$cbockisch$jlxf$nodes$CompilationUnit == null ? (class$de$cbockisch$jlxf$nodes$CompilationUnit = CompilationUnitContext.class$("de.cbockisch.jlxf.nodes.CompilationUnit")) : class$de$cbockisch$jlxf$nodes$CompilationUnit);
        }
        if (definition == null) {
            throw new IllegalNodeTypeException();
        }
        this.definition = (CompilationUnit)definition;
    }

    @Override
    public void setParentContext(Context parentContext) throws IllegalContextException {
        this.parentContext = parentContext;
    }

    @Override
    public Context getParentContext() {
        if (this.parentContext == null) {
            throw new NoParentContextSetException();
        }
        return this.parentContext;
    }

    @Override
    public String getNamespace() {
        if (this.definition == null) {
            throw new NoDefinitionSetException();
        }
        String result = this.definition.getPackageName();
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getName() {
        return this.url.toString();
    }

    @Override
    public Node getDefinition() {
        if (this.definition == null) {
            throw new NoDefinitionSetException();
        }
        return this.definition;
    }

    @Override
    public Vector<String> getKnownClasses() {
        if (this.definition == null) {
            throw new NoDefinitionSetException();
        }
        Vector<String> result = new Vector<String>();
        Enumeration<String> imports = this.definition.getImportNames().elements();
        while (imports.hasMoreElements()) {
            String current = imports.nextElement();
            if (current.endsWith(".*")) continue;
            result.add(current);
        }
        return result;
    }

    @Override
    public Vector<String> getKnownPackages() {
        if (this.definition == null) {
            throw new NoDefinitionSetException();
        }
        Vector<String> result = new Vector<String>();
        result.add("");
        if (this.definition.getPackageName() != null && !this.definition.getPackageName().equals("")) {
            result.add(this.definition.getPackageName());
        }
        result.add("java.lang");
        result.add("kareltherobot");
        Enumeration<String> imports = this.definition.getImportNames().elements();
        while (imports.hasMoreElements()) {
            String current = imports.nextElement();
            if (!current.endsWith(".*")) continue;
            result.add(current.substring(0, current.length() - 2));
        }
        return result;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

