/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class NodeGenerator {
    static String packageName = "de.cbockisch.jlxf.nodes";
    static String basePath;
    static String visitorFilename;
    static Hashtable<String, String> superClasses;
    static Vector<String> componentTypes;
    static boolean debug;
    static String visitor;

    public static void main(String[] args) throws Exception {
        String result;
        String current;
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        basePath = args[1];
        visitorFilename = args[2];
        if (args.length == 4) {
            debug = args[3].equals("-debug");
        }
        superClasses.put("Node", "notNode");
        superClasses.put("String", "notNode");
        superClasses.put("int", "notNode");
        superClasses.put("long", "notNode");
        superClasses.put("boolean", "notNode");
        superClasses.put("char", "notNode");
        superClasses.put("double", "notNode");
        try {
            while (reader.ready()) {
                NodeGenerator.process(reader);
            }
        }
        catch (NullPointerException exception) {
            // empty catch block
        }
        BufferedReader visitorReader = new BufferedReader(new FileReader(visitorFilename));
        String visitorResult = "";
        while (visitorReader.ready()) {
            String visitorLine = visitorReader.readLine();
            visitorResult = visitorResult + visitorLine + "\n";
            if (!visitorLine.trim().startsWith("// BEGIN generated")) continue;
            visitorResult = visitorResult + "\n" + visitor;
            while (!visitorLine.trim().startsWith("// END   generated")) {
                visitorLine = visitorReader.readLine();
            }
            visitorResult = visitorResult + visitorLine + "\n";
        }
        visitorReader.close();
        PrintWriter writer = new PrintWriter(new FileWriter(visitorFilename));
        writer.print(visitorResult);
        writer.close();
        Enumeration<String> enumeration = superClasses.elements();
        while (enumeration.hasMoreElements()) {
            current = enumeration.nextElement();
            result = superClasses.get(current);
            if (result != null) continue;
            NodeGenerator.debug(current);
        }
        enumeration = componentTypes.elements();
        while (enumeration.hasMoreElements()) {
            current = enumeration.nextElement();
            result = superClasses.get(current);
            if (result != null) continue;
            NodeGenerator.debug(current);
        }
    }

    private static void debug(Object out) {
        if (debug) {
            System.out.println(out);
        }
    }

    private static void process(BufferedReader reader) throws Exception {
        String line;
        StringTokenizer tokenizer = new StringTokenizer(reader.readLine(), " \r\n", false);
        boolean isAbstract = false;
        String className = "";
        String superName = "";
        className = tokenizer.nextToken();
        if (className.equals("abstract")) {
            isAbstract = true;
            className = tokenizer.nextToken();
        }
        superName = tokenizer.nextToken();
        superClasses.put(className, superName);
        String result = new String();
        result = result + "package " + packageName + ";\n\n";
        result = result + "import de.cbockisch.jlxf.visitors.Visitor;\n";
        result = result + "import de.cbockisch.jlxf.visitors.VisitorException;\n";
        result = result + "import de.cbockisch.jlxf.context.Context;\n";
        result = result + "import java.util.Enumeration;\n";
        result = result + "import java.util.Vector;\n\n";
        if (isAbstract) {
            result = result + "abstract ";
        }
        result = result + "public class " + className + " extends " + superName + "\n{\n\n";
        visitor = visitor + "\tpublic void accept" + className + "( " + className + " node, Context context ) throws VisitorException\n\t{\n";
        visitor = visitor + "\t\taccept" + superName + "( node, context );\n\t}\n\n";
        String getChildrenBody = new String();
        String getIteratorBody = new String();
        String getterSetter = new String();
        while (!(line = reader.readLine()).trim().equals("")) {
            String fieldName;
            tokenizer = new StringTokenizer(line, " \n\r\t", false);
            boolean isVector = false;
            String componentType = tokenizer.nextToken();
            if (componentType.equals("Vector")) {
                isVector = true;
                componentType = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreTokens()) {
                fieldName = tokenizer.nextToken();
                NodeGenerator.debug(fieldName);
            } else {
                fieldName = componentType;
            }
            if (tokenizer.hasMoreElements()) {
                throw new Exception("too many tokens " + line + ": " + className);
            }
            componentTypes.add(componentType);
            String fieldNameLow = Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1);
            if (isVector) {
                result = result + "\tprivate Vector<" + componentType + "> " + fieldNameLow + "s = new Vector<" + componentType + ">();\n";
                if (superClasses.get(componentType) == null || !superClasses.get(componentType).equals("notNode")) {
                    getChildrenBody = getChildrenBody + "\t\tresult.addAll( " + fieldNameLow + "s );\n";
                }
                if (superClasses.get(componentType) == null || !superClasses.get(componentType).equals("notNode")) {
                    getIteratorBody = getIteratorBody + "\t\t\ttemp = new de.cbockisch.jlxf.util.Iterator.VectorNodeListElement( " + fieldNameLow + "s );\n" + "\t\t\tprevious.setNextElement( temp );" + "\n\t\t\tprevious = temp;\n";
                }
                getterSetter = getterSetter + "\tpublic void set" + fieldName + "s( Vector<" + componentType + "> " + fieldNameLow + "s )\n";
                getterSetter = getterSetter + "\t{\n\t\tthis." + fieldNameLow + "s = " + fieldNameLow + "s;\n\t}\n\n";
                getterSetter = getterSetter + "\tpublic void add" + fieldName + "( " + componentType + " " + fieldNameLow + ")\n";
                getterSetter = getterSetter + "\t{\n\t\tthis." + fieldNameLow + "s.add( " + fieldNameLow + " );\n\t}\n\n";
                getterSetter = getterSetter + "\tpublic Vector<" + componentType + "> get" + fieldName + "s()\n";
                getterSetter = getterSetter + "\t{\n\t\treturn this." + fieldNameLow + "s;\n\t}\n\n";
                continue;
            }
            result = result + "\tprivate " + componentType + " " + fieldNameLow + ";\n";
            if (superClasses.get(componentType) == null || !superClasses.get(componentType).equals("notNode")) {
                getChildrenBody = getChildrenBody + "\t\tif( " + fieldNameLow + " != null )\n\t\t\tresult.add( " + fieldNameLow + " );\n";
            }
            if (superClasses.get(componentType) == null || !superClasses.get(componentType).equals("notNode")) {
                getIteratorBody = getIteratorBody + "\t\t\ttemp = new de.cbockisch.jlxf.util.Iterator.NodeListElement() {\n" + "\t\t\t\tpublic Node getValue() { return " + fieldNameLow + "; }\n" + "\t\t\t\tpublic void remove() { " + fieldNameLow + " = null; }\n" + "\t\t\t\tpublic void replace( Node newElement ) { " + fieldNameLow + " = (" + componentType + ") newElement; }\n\t\t\t};" + "\t\t\tprevious.setNextElement( temp );\n" + "\t\t\tprevious = temp;\n";
            }
            getterSetter = getterSetter + "\tpublic void set" + fieldName + "( " + componentType + " " + fieldNameLow + " )\n";
            getterSetter = getterSetter + "\t{\n\t\tthis." + fieldNameLow + " = " + fieldNameLow + ";\n\t}\n\n";
            getterSetter = getterSetter + "\tpublic " + componentType + " get" + fieldName + "()\n";
            getterSetter = getterSetter + "\t{\n\t\treturn this." + fieldNameLow + ";\n\t}\n\n";
        }
        result = result + getterSetter;
        result = result + "\tpublic Enumeration<Node> getChildren()\n\t{\n";
        result = result + "\t\tVector<Node> result = new Vector<Node>();\n";
        result = result + getChildrenBody;
        result = result + "\t\treturn result.elements();\n";
        result = result + "\t}\n\n";
        result = result + "\tpublic de.cbockisch.jlxf.util.Iterator getIterator()\n\t{\n";
        result = result + "\t\treturn new de.cbockisch.jlxf.util.Iterator() {\n";
        result = result + "\t\t\tprotected void init()\n\t\t\t{\n\t\t\tde.cbockisch.jlxf.util.Iterator.NodeListElement temp, previous = current;\n";
        result = result + getIteratorBody;
        result = result + "\t\t\t}\n\t\t};\t}\n\n";
        result = result + "\tpublic void visit( Visitor visitor, Context context ) throws VisitorException\n\t{\n\t\tvisitor.accept" + className + "( this, context );\n\t}\n\n";
        result = result + "}";
        PrintWriter writer = new PrintWriter(new FileWriter(basePath + "/" + className + ".java"));
        writer.print(result);
        writer.close();
    }

    static {
        superClasses = new Hashtable();
        componentTypes = new Vector();
        debug = false;
        visitor = new String();
    }
}

