/*
 * Decompiled with CFR 0.152.
 */
package de.cbockisch.jlxf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class ASCII_UCodeESC_CharStream {
    public static final boolean staticFlag = true;
    public static int bufpos = -1;
    static int bufsize;
    static int available;
    static int tokenBegin;
    private static int[] bufline;
    private static int[] bufcolumn;
    private static int column;
    private static int line;
    private static Reader inputStream;
    private static boolean prevCharIsCR;
    private static boolean prevCharIsLF;
    private static char[] nextCharBuf;
    private static char[] buffer;
    private static int maxNextCharInd;
    private static int nextCharInd;
    private static int inBuf;

    static final int hexval(char c) throws IOException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IOException();
    }

    private static final void ExpandBuff(boolean wrapAround) {
        char[] newbuffer = new char[bufsize + 2048];
        int[] newbufline = new int[bufsize + 2048];
        int[] newbufcolumn = new int[bufsize + 2048];
        try {
            if (wrapAround) {
                System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
                System.arraycopy(buffer, 0, newbuffer, bufsize - tokenBegin, bufpos);
                buffer = newbuffer;
                System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
                System.arraycopy(bufline, 0, newbufline, bufsize - tokenBegin, bufpos);
                bufline = newbufline;
                System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
                System.arraycopy(bufcolumn, 0, newbufcolumn, bufsize - tokenBegin, bufpos);
                bufcolumn = newbufcolumn;
                bufpos += bufsize - tokenBegin;
            } else {
                System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
                buffer = newbuffer;
                System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
                bufline = newbufline;
                System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
                bufcolumn = newbufcolumn;
                bufpos -= tokenBegin;
            }
        }
        catch (Throwable t) {
            throw new Error(t.getMessage());
        }
        available = bufsize += 2048;
        tokenBegin = 0;
    }

    private static final void FillBuff() throws IOException {
        if (maxNextCharInd == 4096) {
            nextCharInd = 0;
            maxNextCharInd = 0;
        }
        try {
            int i = inputStream.read(nextCharBuf, maxNextCharInd, 4096 - maxNextCharInd);
            if (i == -1) {
                inputStream.close();
                throw new IOException();
            }
            maxNextCharInd += i;
            return;
        }
        catch (IOException e) {
            if (bufpos != 0) {
                --bufpos;
                ASCII_UCodeESC_CharStream.backup(0);
            } else {
                ASCII_UCodeESC_CharStream.bufline[ASCII_UCodeESC_CharStream.bufpos] = line;
                ASCII_UCodeESC_CharStream.bufcolumn[ASCII_UCodeESC_CharStream.bufpos] = column;
            }
            throw e;
        }
    }

    private static final char ReadByte() throws IOException {
        if (++nextCharInd >= maxNextCharInd) {
            ASCII_UCodeESC_CharStream.FillBuff();
        }
        return nextCharBuf[nextCharInd];
    }

    public static final char BeginToken() throws IOException {
        if (inBuf > 0) {
            --inBuf;
            tokenBegin = bufpos == bufsize - 1 ? (bufpos = 0) : (bufpos = bufpos + 1);
            return buffer[tokenBegin];
        }
        tokenBegin = 0;
        bufpos = -1;
        return ASCII_UCodeESC_CharStream.readChar();
    }

    private static final void AdjustBuffSize() {
        if (available == bufsize) {
            if (tokenBegin > 2048) {
                bufpos = 0;
                available = tokenBegin;
            } else {
                ASCII_UCodeESC_CharStream.ExpandBuff(false);
            }
        } else if (available > tokenBegin) {
            available = bufsize;
        } else if (tokenBegin - available < 2048) {
            ASCII_UCodeESC_CharStream.ExpandBuff(true);
        } else {
            available = tokenBegin;
        }
    }

    private static final void UpdateLineColumn(char c) {
        ++column;
        if (prevCharIsLF) {
            prevCharIsLF = false;
            column = 1;
            ++line;
        } else if (prevCharIsCR) {
            prevCharIsCR = false;
            if (c == '\n') {
                prevCharIsLF = true;
            } else {
                column = 1;
                ++line;
            }
        }
        switch (c) {
            case '\r': {
                prevCharIsCR = true;
                break;
            }
            case '\n': {
                prevCharIsLF = true;
                break;
            }
            case '\t': {
                --column;
                column += 8 - (column & 7);
                break;
            }
        }
        ASCII_UCodeESC_CharStream.bufline[ASCII_UCodeESC_CharStream.bufpos] = line;
        ASCII_UCodeESC_CharStream.bufcolumn[ASCII_UCodeESC_CharStream.bufpos] = column;
    }

    public static final char readChar() throws IOException {
        char c;
        if (inBuf > 0) {
            --inBuf;
            return buffer[bufpos == bufsize - 1 ? (bufpos = 0) : (bufpos = bufpos + 1)];
        }
        if (++bufpos == available) {
            ASCII_UCodeESC_CharStream.AdjustBuffSize();
        }
        ASCII_UCodeESC_CharStream.buffer[ASCII_UCodeESC_CharStream.bufpos] = c = (char)(0xFF & ASCII_UCodeESC_CharStream.ReadByte());
        if (c == '\\') {
            ASCII_UCodeESC_CharStream.UpdateLineColumn(c);
            int backSlashCnt = 1;
            while (true) {
                if (++bufpos == available) {
                    ASCII_UCodeESC_CharStream.AdjustBuffSize();
                }
                try {
                    ASCII_UCodeESC_CharStream.buffer[ASCII_UCodeESC_CharStream.bufpos] = c = (char)(0xFF & ASCII_UCodeESC_CharStream.ReadByte());
                    if (c != '\\') {
                        ASCII_UCodeESC_CharStream.UpdateLineColumn(c);
                        if (c == 'u' && (backSlashCnt & 1) == 1) {
                            if (--bufpos >= 0) break;
                            bufpos = bufsize - 1;
                            break;
                        }
                        ASCII_UCodeESC_CharStream.backup(backSlashCnt);
                        return '\\';
                    }
                }
                catch (IOException e) {
                    if (backSlashCnt > 1) {
                        ASCII_UCodeESC_CharStream.backup(backSlashCnt);
                    }
                    return '\\';
                }
                ASCII_UCodeESC_CharStream.UpdateLineColumn(c);
                ++backSlashCnt;
            }
            try {
                while ((c = (char)(0xFF & ASCII_UCodeESC_CharStream.ReadByte())) == 'u') {
                    ++column;
                }
                ASCII_UCodeESC_CharStream.buffer[ASCII_UCodeESC_CharStream.bufpos] = c = (char)(ASCII_UCodeESC_CharStream.hexval(c) << 12 | ASCII_UCodeESC_CharStream.hexval((char)(0xFF & ASCII_UCodeESC_CharStream.ReadByte())) << 8 | ASCII_UCodeESC_CharStream.hexval((char)(0xFF & ASCII_UCodeESC_CharStream.ReadByte())) << 4 | ASCII_UCodeESC_CharStream.hexval((char)(0xFF & ASCII_UCodeESC_CharStream.ReadByte())));
                column += 4;
            }
            catch (IOException e) {
                throw new Error("Invalid escape character at line " + line + " column " + column + ".");
            }
            if (backSlashCnt == 1) {
                return c;
            }
            ASCII_UCodeESC_CharStream.backup(backSlashCnt - 1);
            return '\\';
        }
        ASCII_UCodeESC_CharStream.UpdateLineColumn(c);
        return c;
    }

    public static final int getColumn() {
        return bufcolumn[bufpos];
    }

    public static final int getLine() {
        return bufline[bufpos];
    }

    public static final int getEndColumn() {
        return bufcolumn[bufpos];
    }

    public static final int getEndLine() {
        return bufline[bufpos];
    }

    public static final int getBeginColumn() {
        return bufcolumn[tokenBegin];
    }

    public static final int getBeginLine() {
        return bufline[tokenBegin];
    }

    public static final void backup(int amount) {
        inBuf += amount;
        if ((bufpos -= amount) < 0) {
            bufpos += bufsize;
        }
    }

    public ASCII_UCodeESC_CharStream(Reader dstream, int startline, int startcolumn, int buffersize) {
        if (inputStream != null) {
            throw new Error("\n   ERROR: Second call to the constructor of a static ASCII_UCodeESC_CharStream.  You must\n       either use ReInit() or set the JavaCC option STATIC to false\n       during the generation of this class.");
        }
        inputStream = dstream;
        line = startline;
        column = startcolumn - 1;
        available = bufsize = buffersize;
        buffer = new char[buffersize];
        bufline = new int[buffersize];
        bufcolumn = new int[buffersize];
        nextCharBuf = new char[4096];
    }

    public ASCII_UCodeESC_CharStream(Reader dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, 4096);
    }

    public void ReInit(Reader dstream, int startline, int startcolumn, int buffersize) {
        inputStream = dstream;
        line = startline;
        column = startcolumn - 1;
        if (buffer == null || buffersize != buffer.length) {
            available = bufsize = buffersize;
            buffer = new char[buffersize];
            bufline = new int[buffersize];
            bufcolumn = new int[buffersize];
            nextCharBuf = new char[4096];
        }
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        inBuf = 0;
        tokenBegin = 0;
        bufpos = -1;
        nextCharInd = -1;
    }

    public void ReInit(Reader dstream, int startline, int startcolumn) {
        this.ReInit(dstream, startline, startcolumn, 4096);
    }

    public ASCII_UCodeESC_CharStream(InputStream dstream, int startline, int startcolumn, int buffersize) {
        this(new InputStreamReader(dstream), startline, startcolumn, 4096);
    }

    public ASCII_UCodeESC_CharStream(InputStream dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, 4096);
    }

    public void ReInit(InputStream dstream, int startline, int startcolumn, int buffersize) {
        this.ReInit(new InputStreamReader(dstream), startline, startcolumn, 4096);
    }

    public void ReInit(InputStream dstream, int startline, int startcolumn) {
        this.ReInit(dstream, startline, startcolumn, 4096);
    }

    public static final String GetImage() {
        if (bufpos >= tokenBegin) {
            return new String(buffer, tokenBegin, bufpos - tokenBegin + 1);
        }
        return new String(buffer, tokenBegin, bufsize - tokenBegin) + new String(buffer, 0, bufpos + 1);
    }

    public static final char[] GetSuffix(int len) {
        char[] ret = new char[len];
        if (bufpos + 1 >= len) {
            System.arraycopy(buffer, bufpos - len + 1, ret, 0, len);
        } else {
            System.arraycopy(buffer, bufsize - (len - bufpos - 1), ret, 0, len - bufpos - 1);
            System.arraycopy(buffer, 0, ret, len - bufpos - 1, bufpos + 1);
        }
        return ret;
    }

    public static void Done() {
        nextCharBuf = null;
        buffer = null;
        bufline = null;
        bufcolumn = null;
    }

    public static void adjustBeginLineColumn(int newLine, int newCol) {
        int start = tokenBegin;
        int len = bufpos >= tokenBegin ? bufpos - tokenBegin + inBuf + 1 : bufsize - tokenBegin + bufpos + 1 + inBuf;
        int i = 0;
        int j = 0;
        int k = 0;
        int nextColDiff = 0;
        int columnDiff = 0;
        while (i < len && bufline[j = start % bufsize] == bufline[k = ++start % bufsize]) {
            ASCII_UCodeESC_CharStream.bufline[j] = newLine;
            nextColDiff = columnDiff + bufcolumn[k] - bufcolumn[j];
            ASCII_UCodeESC_CharStream.bufcolumn[j] = newCol + columnDiff;
            columnDiff = nextColDiff;
            ++i;
        }
        if (i < len) {
            ASCII_UCodeESC_CharStream.bufline[j] = newLine++;
            ASCII_UCodeESC_CharStream.bufcolumn[j] = newCol + columnDiff;
            while (i++ < len) {
                j = start % bufsize;
                ASCII_UCodeESC_CharStream.bufline[j] = bufline[j] != bufline[++start % bufsize] ? newLine++ : newLine;
            }
        }
        line = bufline[j];
        column = bufcolumn[j];
    }

    static {
        column = 0;
        line = 1;
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        nextCharInd = -1;
        inBuf = 0;
    }
}

