/*
 * Decompiled with CFR 0.152.
 */
import de.cbockisch.jlxf.execution.Commandline;
import de.cbockisch.jlxf.execution.IllegalUseError;
import de.cbockisch.jlxf.execution.Option;
import de.cbockisch.jlxf.execution.Preprocessor;
import de.cbockisch.jlxf.util.Javac;
import de.cbockisch.jlxf.visitors.KarelJ2JavaVisitor;
import de.cbockisch.jlxf.visitors.Visitor;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Vector;
import kareltherobot.World;

public class Simulator {
    private Preprocessor pp = new Preprocessor();
    private Vector<Visitor> visitors = new Vector();
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void main(String[] args) throws Exception {
        Simulator simulator = new Simulator(args);
    }

    protected Simulator(String[] args) throws Exception {
        this.visitors.add(new KarelJ2JavaVisitor());
        Commandline commandline = null;
        Vector<Option> options = new Vector<Option>();
        options.add(new Option("world", "The name of the world file to be loaded at startup", "file"));
        options.add(new Option("delay", "The delay between robot movements in milliseconds", "milliseconds", "1000"));
        options.add(new Option("avenues", "The number of avenues to be visible", "number", "10"));
        options.add(new Option("streets", "The number of streets to be visible", "number", "15"));
        options.add(new Option("worldimpl", "The World implementation to be used", "classname", "kareltherobot.GUIWorld"));
        try {
            System.out.println("set parameters");
            commandline = this.pp.setParameters(args, this.visitors, options, "Simulator", "Simulator for the simplified Java Syntax defined in Karel J. Robot. Run without arguments for graphical user interface.", new Javac());
            Vector<URL> sourceFiles = commandline.getSourceFiles();
            if (sourceFiles.size() == 0) {
                throw new IllegalUseError("Please specify the taskfile to processs");
            }
            this.runKarel(commandline);
        }
        catch (IllegalUseError error) {
            commandline.printUsage(new PrintWriter(System.out, true), error);
        }
    }

    public void runKarel(Commandline commandline) {
        System.out.println("process");
        if (!this.pp.process()) {
            System.exit(1);
        }
        try {
            System.out.println("initialize World");
            Class.forName(commandline.getOption("worldimpl").getArgument());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
            System.out.println("[" + commandline.getOption("worldimpl").getArgument() + "]");
        }
        try {
            System.out.println("setup world");
            if (commandline.getOption("world").isPresent()) {
                World.readWorld(commandline.getOption("world").getArgument());
            }
            World.setDelay(Integer.parseInt(commandline.getOption("delay").getArgument()));
            World.setAvenues(Integer.parseInt(commandline.getOption("avenues").getArgument()));
            World.setStreets(Integer.parseInt(commandline.getOption("streets").getArgument()));
            Class<?> clazz = Class.forName("KarelTask");
            System.out.println("run karel");
            clazz.getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Simulator.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).invoke(null, new Object[]{new String[0]});
        }
        catch (InvocationTargetException exception) {
            exception.getTargetException().printStackTrace();
        }
        catch (Exception exception) {
            System.err.println("Could not invoke task.");
            exception.printStackTrace();
        }
    }

    public void startGui(Commandline commandline) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

