package kareltherobot;

/**
 * The ur_Robot is the origin of all robots. It handles the communication with the World the robot
 * is in. It also defines the base functionality of a robot. That is some query methods like avenue()
 * or areYouHere() and commands like turnLeft(). The commands take some time to be fulfilled (depending
 * p.e. on the delay of the World). The query functions, though, return immediately.
 */
public class ur_Robot implements Directions
{
	protected Integer robotId;
	
	public ur_Robot( int street, int avenue, int direction, int beepers )
	{
		robotId = World.getWorld().getNewRobot( street, avenue, direction, beepers );
	}
	
	public boolean areYouHere( int street, int avenue ) 
	{
		return ( World.getWorld().getAvenue( robotId ) == avenue ) && ( World.getWorld().getStreet( robotId ) == street );
	}
	
	public int avenue() 
	{
		return World.getWorld().getAvenue( robotId );
	}
	
	public int street() 
	{
		return World.getWorld().getStreet( robotId );
	}
	
	public int direction() 
	{
		return World.getWorld().getDirection( robotId );
	}
	
	public synchronized void move() 
	{
		World.getWorld().move( robotId );
	}
	
	public synchronized void pickBeeper()
	{
		World.getWorld().pickBeeper( robotId );
	}
	
	public synchronized void putBeeper()
	{
		World.getWorld().putBeeper( robotId );
	}

	public synchronized void turnLeft()
	{
		World.getWorld().turnLeft( robotId );
	}
	
	public synchronized void turnOff()
	{
		World.getWorld().turnOff( robotId );
	}

}